/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontent;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletLayoutListenerException;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.List;
import javax.portlet.PortletPreferences;

public class JournalContentPortletLayoutListener
implements PortletLayoutListener {
    private static Log _log = LogFactoryUtil.getLog(JournalContentPortletLayoutListener.class);

    public void onAddToLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Add " + portletId + " to layout " + plid));
        }
        try {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
            String articleId = preferences.getValue("articleId", null);
            if (Validator.isNull((String)articleId)) {
                return;
            }
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)articleId, (boolean)true);
        }
        catch (Exception e2) {
            throw new PortletLayoutListenerException((Throwable)e2);
        }
    }

    public void onMoveInLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Move " + portletId + " from in " + plid));
        }
    }

    public void onRemoveFromLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Remove " + portletId + " from layout " + plid));
        }
        try {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
            String articleId = preferences.getValue("articleId", null);
            if (Validator.isNull((String)articleId)) {
                return;
            }
            JournalContentSearchLocalServiceUtil.deleteArticleContentSearch((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)articleId);
            String[] runtimePortletIds = this.getRuntimePortletIds(layout.getCompanyId(), layout.getGroupId(), articleId);
            if (runtimePortletIds.length > 0) {
                PortletLocalServiceUtil.deletePortlets((long)layout.getCompanyId(), (String[])runtimePortletIds, (long)layout.getPlid());
            }
        }
        catch (Exception e2) {
            throw new PortletLayoutListenerException((Throwable)e2);
        }
    }

    protected String getRuntimePortletId(String xml) throws Exception {
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        String instanceId = rootElement.attributeValue("instance");
        String portletId = rootElement.attributeValue("name");
        if (Validator.isNotNull((String)instanceId)) {
            portletId = String.valueOf(portletId) + "_INSTANCE_" + instanceId;
        }
        return portletId;
    }

    protected String[] getRuntimePortletIds(long companyId, long scopeGroupId, String articleId) throws Exception {
        Group group = GroupLocalServiceUtil.getCompanyGroup((long)companyId);
        JournalArticle article = null;
        try {
            article = JournalArticleLocalServiceUtil.getDisplayArticle((long)scopeGroupId, (String)articleId);
        }
        catch (NoSuchArticleException noSuchArticleException) {}
        if (article == null) {
            try {
                article = JournalArticleLocalServiceUtil.getDisplayArticle((long)group.getGroupId(), (String)articleId);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                return new String[0];
            }
        }
        List<String> portletIds = this.getRuntimePortletIds(article.getContent());
        if (Validator.isNotNull((String)article.getTemplateId())) {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)scopeGroupId, (long)PortalUtil.getClassNameId(DDMStructure.class), (String)article.getTemplateId(), (boolean)true);
            portletIds.addAll(this.getRuntimePortletIds(ddmTemplate.getScript()));
        }
        return portletIds.toArray(new String[portletIds.size()]);
    }

    protected List<String> getRuntimePortletIds(String content) throws Exception {
        UniqueList portletIds = new UniqueList();
        int index = 0;
        while ((index = content.indexOf("<runtime-portlet", index)) != -1) {
            int close1 = content.indexOf("</runtime-portlet>", index);
            int close2 = content.indexOf("/>", index);
            int closeIndex = -1;
            closeIndex = close2 == -1 || close1 != -1 && close1 < close2 ? close1 + "</runtime-portlet>".length() : close2 + "/>".length();
            if (closeIndex == -1) break;
            portletIds.add(this.getRuntimePortletId(content.substring(index, closeIndex)));
            index = closeIndex;
        }
        return portletIds;
    }
}

