/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARFileSizeException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LayoutPrototypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.ExportImportHelper;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.sites.action.ActionUtil;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ImportLayoutsAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(ImportLayoutsAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add_temp")) {
                this.addTempFileEntry(actionRequest, ExportImportHelper.TEMP_FOLDER_NAME);
                this.validateFile(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
            } else if (cmd.equals("delete_temp")) {
                this.deleteTempFileEntry(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
            } else if (cmd.equals("import")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this.importData(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e2) {
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.handleUploadException(portletConfig, actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME, e2);
            }
            if (e2 instanceof LARFileException || e2 instanceof LARFileSizeException || e2 instanceof LARTypeException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof LayoutPrototypeException || e2 instanceof LocaleException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            _log.error((Object)e2, (Throwable)e2);
            SessionErrors.add((PortletRequest)actionRequest, (String)LayoutImportException.class.getName());
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchGroupException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.layouts_admin.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layouts_admin.import_layouts"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = null;
        portletRequestDispatcher = cmd.equals("import") ? portletContext.getRequestDispatcher("/html/portlet/layouts_admin/import_layouts_processes.jsp") : portletContext.getRequestDispatcher("/html/portlet/layouts_admin/import_layouts_resources.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void addTempFileEntry(ActionRequest actionRequest, String folderName) throws Exception {
        block7: {
            UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
            this.checkExceededSizeLimit((HttpServletRequest)uploadPortletRequest);
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            this.deleteTempFileEntry(groupId, folderName);
            InputStream inputStream = null;
            try {
                try {
                    String sourceFileName = uploadPortletRequest.getFileName("file");
                    inputStream = uploadPortletRequest.getFileAsStream("file");
                    String contentType = uploadPortletRequest.getContentType("file");
                    LayoutServiceUtil.addTempFileEntry((long)groupId, (String)sourceFileName, (String)folderName, (InputStream)inputStream, (String)contentType);
                }
                catch (Exception e2) {
                    UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                    if (uploadException == null || !(uploadException.getCause() instanceof FileUploadBase.IOFileUploadException)) {
                        if (uploadException != null && uploadException.isExceededSizeLimit()) {
                            throw new FileSizeException(uploadException.getCause());
                        }
                        throw e2;
                    }
                    StreamUtil.cleanUp((InputStream)inputStream);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(inputStream);
                throw throwable;
            }
            StreamUtil.cleanUp((InputStream)inputStream);
        }
    }

    protected void checkExceededSizeLimit(HttpServletRequest request) throws PortalException {
        UploadException uploadException = (UploadException)request.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            if (uploadException.isExceededSizeLimit()) {
                throw new LARFileSizeException(uploadException.getCause());
            }
            throw new PortalException(uploadException.getCause());
        }
    }

    protected void deleteTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
            LayoutServiceUtil.deleteTempFileEntry((long)themeDisplay.getScopeGroupId(), (String)fileName, (String)folderName);
            jsonObject.put("deleted", Boolean.TRUE.booleanValue());
        }
        catch (Exception exception) {
            String errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", Boolean.FALSE.booleanValue());
            jsonObject.put("errorMessage", errorMessage);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
    }

    protected void deleteTempFileEntry(long groupId, String folderName) throws PortalException, SystemException {
        String[] tempFileEntryNames;
        String[] stringArray = tempFileEntryNames = LayoutServiceUtil.getTempFileEntryNames((long)groupId, (String)folderName);
        int n = tempFileEntryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tempFileEntryName = stringArray[n2];
            LayoutServiceUtil.deleteTempFileEntry((long)groupId, (String)tempFileEntryName, (String)folderName);
            ++n2;
        }
    }

    protected void handleUploadException(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String folderName, Exception e2) throws Exception {
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        response.setContentType("text/html");
        response.setStatus(200);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.deleteTempFileEntry(themeDisplay.getScopeGroupId(), folderName);
        JSONObject jsonObject = StagingUtil.getExceptionMessagesJSONObject((Locale)themeDisplay.getLocale(), (Exception)e2, null);
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
        ServletResponseUtil.write((HttpServletResponse)response, (String)String.valueOf(jsonObject.getInt("status")));
    }

    protected void importData(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        FileEntry fileEntry = ExportImportHelperUtil.getTempFileEntry((long)groupId, (long)themeDisplay.getUserId(), (String)folderName);
        InputStream inputStream = null;
        try {
            inputStream = DLFileEntryLocalServiceUtil.getFileAsStream((long)themeDisplay.getUserId(), (long)fileEntry.getFileEntryId(), (String)fileEntry.getVersion(), (boolean)false);
            this.importData(actionRequest, fileEntry.getTitle(), inputStream);
            this.deleteTempFileEntry(groupId, folderName);
            this.addSuccessMessage(actionRequest, actionResponse);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(inputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)inputStream);
    }

    protected void importData(ActionRequest actionRequest, String fileName, InputStream inputStream) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        LayoutServiceUtil.importLayoutsInBackground((String)fileName, (long)groupId, (boolean)privateLayout, (Map)actionRequest.getParameterMap(), (InputStream)inputStream);
    }

    protected void validateFile(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        Map weakMissingReferences;
        InputStream inputStream;
        ThemeDisplay themeDisplay;
        block4: {
            themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            FileEntry fileEntry = ExportImportHelperUtil.getTempFileEntry((long)groupId, (long)themeDisplay.getUserId(), (String)folderName);
            inputStream = null;
            try {
                inputStream = DLFileEntryLocalServiceUtil.getFileAsStream((long)themeDisplay.getUserId(), (long)fileEntry.getFileEntryId(), (String)fileEntry.getVersion(), (boolean)false);
                MissingReferences missingReferences = this.validateFile(actionRequest, inputStream);
                weakMissingReferences = missingReferences.getWeakMissingReferences();
                if (!weakMissingReferences.isEmpty()) break block4;
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(inputStream);
                throw throwable;
            }
            StreamUtil.cleanUp((InputStream)inputStream);
            return;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (weakMissingReferences != null && !weakMissingReferences.isEmpty()) {
            jsonObject.put("warningMessages", StagingUtil.getWarningMessagesJSONArray((Locale)themeDisplay.getLocale(), (Map)weakMissingReferences, null));
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
        StreamUtil.cleanUp((InputStream)inputStream);
    }

    protected MissingReferences validateFile(ActionRequest actionRequest, InputStream inputStream) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        return LayoutServiceUtil.validateImportLayoutsFile((long)groupId, (boolean)privateLayout, (Map)actionRequest.getParameterMap(), (InputStream)inputStream);
    }
}

