/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.messageboards.NoSuchCategoryException;
import com.liferay.portlet.messageboards.SplitThreadException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.MBTreeWalker;
import com.liferay.portlet.messageboards.service.base.MBThreadLocalServiceBaseImpl;
import com.liferay.portlet.messageboards.util.MBUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MBThreadLocalServiceImpl
extends MBThreadLocalServiceBaseImpl {
    public MBThread addThread(long categoryId, MBMessage message, ServiceContext serviceContext) throws PortalException, SystemException {
        Date now = new Date();
        long threadId = message.getThreadId();
        if (!message.isRoot() || threadId <= 0L) {
            threadId = this.counterLocalService.increment();
        }
        MBThread thread = this.mbThreadPersistence.create(threadId);
        thread.setUuid(serviceContext.getUuid());
        thread.setGroupId(message.getGroupId());
        thread.setCompanyId(message.getCompanyId());
        thread.setUserId(message.getUserId());
        thread.setUserName(message.getUserName());
        thread.setCreateDate(serviceContext.getCreateDate(now));
        thread.setModifiedDate(serviceContext.getModifiedDate(now));
        thread.setCategoryId(categoryId);
        thread.setRootMessageId(message.getMessageId());
        thread.setRootMessageUserId(message.getUserId());
        if (message.isAnonymous()) {
            thread.setLastPostByUserId(0L);
        } else {
            thread.setLastPostByUserId(message.getUserId());
        }
        thread.setLastPostDate(message.getCreateDate());
        if (message.getPriority() != -1.0) {
            thread.setPriority(message.getPriority());
        }
        thread.setStatus(message.getStatus());
        thread.setStatusByUserId(message.getStatusByUserId());
        thread.setStatusByUserName(message.getStatusByUserName());
        thread.setStatusDate(message.getStatusDate());
        this.mbThreadPersistence.update((BaseModel)thread);
        if (categoryId >= 0L) {
            this.assetEntryLocalService.updateEntry(message.getUserId(), message.getGroupId(), thread.getStatusDate(), thread.getLastPostDate(), MBThread.class.getName(), thread.getThreadId(), thread.getUuid(), 0L, new long[0], new String[0], false, null, null, null, null, String.valueOf(thread.getRootMessageId()), null, null, null, null, 0, 0, null, false);
        }
        return thread;
    }

    public void deleteThread(long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        this.mbThreadLocalService.deleteThread(thread);
    }

    @SystemEvent(action=1, send=false, type=1)
    public void deleteThread(MBThread thread) throws PortalException, SystemException {
        AssetEntry assetEntry;
        MBMessage rootMessage;
        block8: {
            rootMessage = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
            Indexer messageIndexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            long folderId = thread.getAttachmentsFolderId();
            if (folderId != 0L) {
                PortletFileRepositoryUtil.deleteFolder((long)folderId);
            }
            this.subscriptionLocalService.deleteSubscriptions(thread.getCompanyId(), MBThread.class.getName(), thread.getThreadId());
            this.mbThreadFlagPersistence.removeByThreadId(thread.getThreadId());
            List messages = this.mbMessagePersistence.findByThreadId(thread.getThreadId());
            for (MBMessage message : messages) {
                this.ratingsStatsLocalService.deleteStats(message.getWorkflowClassName(), message.getMessageId());
                this.assetEntryLocalService.deleteEntry(message.getWorkflowClassName(), message.getMessageId());
                if (!message.isDiscussion()) {
                    this.resourceLocalService.deleteResource(message.getCompanyId(), message.getWorkflowClassName(), 4, message.getMessageId());
                }
                this.mbMessagePersistence.remove((BaseModel)message);
                messageIndexer.delete((Object)message);
                if (!message.isDiscussion()) {
                    this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), message.getUserId());
                }
                this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(message.getCompanyId(), message.getGroupId(), message.getWorkflowClassName(), message.getMessageId());
            }
            if (rootMessage.getCategoryId() != 0L && rootMessage.getCategoryId() != -1L) {
                try {
                    MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(thread.getCategoryId());
                    MBUtil.updateCategoryStatistics(category.getCompanyId(), category.getCategoryId());
                }
                catch (NoSuchCategoryException nsce) {
                    if (thread.isInTrash()) break block8;
                    throw nsce;
                }
            }
        }
        if ((assetEntry = this.assetEntryLocalService.fetchEntry(MBThread.class.getName(), thread.getThreadId())) != null) {
            assetEntry.setTitle(rootMessage.getSubject());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
        this.assetEntryLocalService.deleteEntry(MBThread.class.getName(), thread.getThreadId());
        this.trashEntryLocalService.deleteEntry(MBThread.class.getName(), thread.getThreadId());
        Indexer threadIndexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        threadIndexer.delete((Object)thread);
        this.mbThreadPersistence.remove((BaseModel)thread);
    }

    public void deleteThreads(long groupId, long categoryId) throws PortalException, SystemException {
        this.deleteThreads(groupId, categoryId, true);
    }

    public void deleteThreads(long groupId, long categoryId, boolean includeTrashedEntries) throws PortalException, SystemException {
        List threads = this.mbThreadPersistence.findByG_C(groupId, categoryId);
        for (MBThread thread : threads) {
            if (!includeTrashedEntries && thread.isInTrashExplicitly()) continue;
            this.mbThreadLocalService.deleteThread(thread);
        }
        if (this.mbThreadPersistence.countByGroupId(groupId) == 0) {
            PortletFileRepositoryUtil.deletePortletRepository((long)groupId, (String)"19");
        }
    }

    public MBThread fetchThread(long threadId) throws SystemException {
        return this.mbThreadPersistence.fetchByPrimaryKey(threadId);
    }

    public int getCategoryThreadsCount(long groupId, long categoryId, int status) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_C(groupId, categoryId);
        }
        return this.mbThreadPersistence.countByG_C_S(groupId, categoryId, status);
    }

    public List<MBThread> getGroupThreads(long groupId, int status, int start, int end) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getGroupThreads(groupId, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, boolean subscribed, boolean includeAnonymous, QueryDefinition queryDefinition) throws SystemException {
        if (userId <= 0L) {
            return this.getGroupThreads(groupId, queryDefinition);
        }
        if (subscribed) {
            return this.mbThreadFinder.findByS_G_U_C(groupId, userId, null, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.findByG_U_C(groupId, userId, null, queryDefinition);
        }
        return this.mbThreadFinder.findByG_U_C_A(groupId, userId, null, false, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, boolean subscribed, QueryDefinition queryDefinition) throws SystemException {
        return this.getGroupThreads(groupId, userId, subscribed, true, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous, int start, int end) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getGroupThreads(groupId, userId, subscribed, includeAnonymous, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, int start, int end) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getGroupThreads(groupId, userId, subscribed, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, int start, int end) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getGroupThreads(groupId, userId, false, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, QueryDefinition queryDefinition) throws SystemException {
        return this.getGroupThreads(groupId, userId, false, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, QueryDefinition queryDefinition) throws SystemException {
        if (queryDefinition.isExcludeStatus()) {
            return this.mbThreadPersistence.findByG_NotC_NotS(groupId, -1L, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd());
        }
        return this.mbThreadPersistence.findByG_NotC_S(groupId, -1L, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd());
    }

    public int getGroupThreadsCount(long groupId, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getGroupThreadsCount(groupId, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, long userId, boolean subscribed, boolean includeAnonymous, QueryDefinition queryDefinition) throws SystemException {
        if (userId <= 0L) {
            return this.getGroupThreadsCount(groupId, queryDefinition);
        }
        if (subscribed) {
            return this.mbThreadFinder.countByS_G_U_C(groupId, userId, null, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.countByG_U_C(groupId, userId, null, queryDefinition);
        }
        return this.mbThreadFinder.countByG_U_C_A(groupId, userId, null, false, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, long userId, boolean subscribed, QueryDefinition queryDefinition) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, subscribed, true, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getGroupThreadsCount(groupId, userId, false, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getGroupThreadsCount(groupId, userId, subscribed, true, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getGroupThreadsCount(groupId, userId, subscribed, includeAnonymous, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, long userId, QueryDefinition queryDefinition) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, false, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, QueryDefinition queryDefinition) throws SystemException {
        if (queryDefinition.isExcludeStatus()) {
            return this.mbThreadPersistence.countByG_NotC_NotS(groupId, -1L, queryDefinition.getStatus());
        }
        return this.mbThreadPersistence.countByG_NotC_S(groupId, -1L, queryDefinition.getStatus());
    }

    public List<MBThread> getNoAssetThreads() throws SystemException {
        return this.mbThreadFinder.findByNoAssets();
    }

    public List<MBThread> getPriorityThreads(long categoryId, double priority) throws PortalException, SystemException {
        return this.getPriorityThreads(categoryId, priority, false);
    }

    public List<MBThread> getPriorityThreads(long categoryId, double priority, boolean inherit) throws PortalException, SystemException {
        if (!inherit) {
            return this.mbThreadPersistence.findByC_P(categoryId, priority);
        }
        ArrayList<MBThread> threads = new ArrayList<MBThread>();
        while (categoryId != 0L && categoryId != -1L) {
            threads.addAll(0, this.mbThreadPersistence.findByC_P(categoryId, priority));
            MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
            categoryId = category.getParentCategoryId();
        }
        return threads;
    }

    public MBThread getThread(long threadId) throws PortalException, SystemException {
        return this.mbThreadPersistence.findByPrimaryKey(threadId);
    }

    public List<MBThread> getThreads(long groupId, long categoryId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.findByG_C(groupId, categoryId, start, end);
        }
        return this.mbThreadPersistence.findByG_C_S(groupId, categoryId, status, start, end);
    }

    public int getThreadsCount(long groupId, long categoryId, int status) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_C(groupId, categoryId);
        }
        return this.mbThreadPersistence.countByG_C_S(groupId, categoryId, status);
    }

    public boolean hasAnswerMessage(long threadId) throws SystemException {
        int count = this.mbMessagePersistence.countByT_A(threadId, true);
        return count > 0;
    }

    @BufferedIncrement(configuration="MBThread", incrementClass=NumberIncrement.class)
    public MBThread incrementViewCounter(long threadId, int increment) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        if (ExportImportThreadLocal.isImportInProcess()) {
            return thread;
        }
        thread.setViewCount(thread.getViewCount() + increment);
        this.mbThreadPersistence.update((BaseModel)thread);
        return thread;
    }

    public void moveDependentsToTrash(long groupId, long threadId, long trashEntryId) throws PortalException, SystemException {
        HashSet<Long> userIds = new HashSet<Long>();
        List messages = this.mbMessageLocalService.getThreadMessages(threadId, -1);
        for (MBMessage message : messages) {
            if (message.isDiscussion()) continue;
            int oldStatus = message.getStatus();
            message.setStatus(8);
            this.mbMessagePersistence.update((BaseModel)message);
            userIds.add(message.getUserId());
            int status = oldStatus;
            if (oldStatus == 1) {
                status = 2;
            }
            if (oldStatus != 0) {
                this.trashVersionLocalService.addTrashVersion(trashEntryId, MBMessage.class.getName(), message.getMessageId(), status, null);
            }
            if (oldStatus == 0) {
                this.assetEntryLocalService.updateVisible(MBMessage.class.getName(), message.getMessageId(), false);
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
            if (oldStatus != 1) continue;
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(message.getCompanyId(), message.getGroupId(), MBMessage.class.getName(), message.getMessageId());
        }
        Iterator iterator = userIds.iterator();
        while (iterator.hasNext()) {
            long userId = (Long)iterator.next();
            this.mbStatsUserLocalService.updateStatsUser(groupId, userId);
        }
    }

    public MBThread moveThread(long groupId, long categoryId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        long oldCategoryId = thread.getCategoryId();
        MBCategory oldCategory = null;
        if (oldCategoryId != 0L) {
            oldCategory = this.mbCategoryPersistence.fetchByPrimaryKey(oldCategoryId);
        }
        MBCategory category = null;
        if (categoryId != 0L) {
            category = this.mbCategoryPersistence.fetchByPrimaryKey(categoryId);
        }
        thread.setModifiedDate(new Date());
        thread.setCategoryId(categoryId);
        this.mbThreadPersistence.update((BaseModel)thread);
        List messages = this.mbMessagePersistence.findByG_C_T(groupId, oldCategoryId, thread.getThreadId());
        for (MBMessage message : messages) {
            message.setCategoryId(categoryId);
            this.mbMessagePersistence.update((BaseModel)message);
            if (message.isDiscussion()) continue;
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        if (oldCategory != null && categoryId != oldCategoryId) {
            MBUtil.updateCategoryStatistics(oldCategory.getCompanyId(), oldCategory.getCategoryId());
        }
        if (category != null && categoryId != oldCategoryId) {
            MBUtil.updateCategoryStatistics(category.getCompanyId(), category.getCategoryId());
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        indexer.reindex((Object)thread);
        return thread;
    }

    public MBThread moveThreadFromTrash(long userId, long categoryId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        if (thread.isInTrashExplicitly()) {
            this.restoreThreadFromTrash(userId, threadId);
        } else {
            TrashEntry trashEntry = thread.getTrashEntry();
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(trashEntry.getEntryId(), MBThread.class.getName(), thread.getThreadId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, threadId, status);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this.restoreDependentsFromTrash(thread.getGroupId(), threadId, trashEntry.getEntryId());
        }
        return this.moveThread(thread.getGroupId(), categoryId, threadId);
    }

    public void moveThreadsToTrash(long groupId, long userId) throws PortalException, SystemException {
        List threads = this.mbThreadPersistence.findByGroupId(groupId);
        for (MBThread thread : threads) {
            this.moveThreadToTrash(userId, thread);
        }
    }

    public MBThread moveThreadToTrash(long userId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        return this.moveThreadToTrash(userId, thread);
    }

    public MBThread moveThreadToTrash(long userId, MBThread thread) throws PortalException, SystemException {
        if (thread.getCategoryId() == -1L) {
            return thread;
        }
        int oldStatus = thread.getStatus();
        if (oldStatus == 1) {
            thread.setStatus(2);
            this.mbThreadPersistence.update((BaseModel)thread);
        }
        thread = this.updateStatus(userId, thread.getThreadId(), 8);
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, thread.getGroupId(), MBThread.class.getName(), thread.getThreadId(), thread.getUuid(), null, oldStatus, null, null);
        this.moveDependentsToTrash(thread.getGroupId(), thread.getThreadId(), trashEntry.getEntryId());
        MBMessage message = this.mbMessageLocalService.getMBMessage(thread.getRootMessageId());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("rootMessageId", thread.getRootMessageId());
        extraDataJSONObject.put("title", message.getSubject());
        this.socialActivityLocalService.addActivity(userId, thread.getGroupId(), MBThread.class.getName(), thread.getThreadId(), 10007, extraDataJSONObject.toString(), 0L);
        return thread;
    }

    public void restoreDependentsFromTrash(long groupId, long threadId, long trashEntryId) throws PortalException, SystemException {
        HashSet<Long> userIds = new HashSet<Long>();
        List messages = this.mbMessageLocalService.getThreadMessages(threadId, -1);
        for (MBMessage message : messages) {
            if (message.isDiscussion()) continue;
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(trashEntryId, MBMessage.class.getName(), message.getMessageId());
            int oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            message.setStatus(oldStatus);
            this.mbMessagePersistence.update((BaseModel)message);
            userIds.add(message.getUserId());
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            if (oldStatus == 0) {
                this.assetEntryLocalService.updateVisible(MBMessage.class.getName(), message.getMessageId(), true);
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        Iterator iterator = userIds.iterator();
        while (iterator.hasNext()) {
            long userId = (Long)iterator.next();
            this.mbStatsUserLocalService.updateStatsUser(groupId, userId);
        }
    }

    public void restoreThreadFromTrash(long userId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.getThread(threadId);
        if (thread.getCategoryId() == -1L) {
            return;
        }
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(MBThread.class.getName(), threadId);
        this.updateStatus(userId, threadId, trashEntry.getStatus());
        this.restoreDependentsFromTrash(thread.getGroupId(), threadId, trashEntry.getEntryId());
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        MBMessage message = this.mbMessageLocalService.getMBMessage(thread.getRootMessageId());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("rootMessageId", thread.getRootMessageId());
        extraDataJSONObject.put("title", message.getSubject());
        this.socialActivityLocalService.addActivity(userId, thread.getGroupId(), MBThread.class.getName(), thread.getThreadId(), 10008, extraDataJSONObject.toString(), 0L);
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException, SystemException {
        return this.search(groupId, userId, creatorUserId, 0L, 0L, status, start, end);
    }

    public Hits search(long groupId, long userId, long creatorUserId, long startDate, long endDate, int status, int start, int end) throws PortalException, SystemException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)MBThread.class.getName());
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        if (endDate > 0L) {
            searchContext.setAttribute("endDate", (Serializable)Long.valueOf(endDate));
        }
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("participantUserId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        if (startDate > 0L) {
            searchContext.setAttribute("startDate", (Serializable)Long.valueOf(startDate));
        }
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("lastPostDate", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return indexer.search(searchContext);
    }

    public MBThread splitThread(long messageId, String subject, ServiceContext serviceContext) throws PortalException, SystemException {
        Indexer indexer;
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        if (message.isRoot()) {
            throw new SplitThreadException();
        }
        MBCategory category = message.getCategory();
        MBThread oldThread = message.getThread();
        MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(oldThread.getRootMessageId());
        this.mbMessageLocalService.updateAnswer(message, false, true);
        MBThread thread = this.addThread(message.getCategoryId(), message, serviceContext);
        oldThread.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        this.mbThreadPersistence.update((BaseModel)oldThread);
        if (Validator.isNotNull((String)subject)) {
            MBMessageDisplay messageDisplay = this.mbMessageService.getMessageDisplay(messageId, -1, "tree", false);
            MBTreeWalker treeWalker = messageDisplay.getTreeWalker();
            List messages = treeWalker.getMessages();
            int[] range = treeWalker.getChildrenRange(message);
            int i2 = range[0];
            while (i2 < range[1]) {
                MBMessage curMessage = (MBMessage)messages.get(i2);
                String oldSubject = message.getSubject();
                String curSubject = curMessage.getSubject();
                curSubject = oldSubject.startsWith("RE: ") ? StringUtil.replace((String)curSubject, (String)rootMessage.getSubject(), (String)subject) : StringUtil.replace((String)curSubject, (String)oldSubject, (String)subject);
                curMessage.setSubject(curSubject);
                this.mbMessagePersistence.update((BaseModel)curMessage);
                ++i2;
            }
            message.setSubject(subject);
        }
        message.setThreadId(thread.getThreadId());
        message.setRootMessageId(thread.getRootMessageId());
        message.setParentMessageId(0L);
        this.mbMessagePersistence.update((BaseModel)message);
        if (!message.isDiscussion()) {
            indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        this.moveChildrenMessages(message, category, oldThread.getThreadId());
        MBUtil.updateThreadMessageCount(thread.getCompanyId(), thread.getThreadId());
        MBUtil.updateThreadMessageCount(oldThread.getCompanyId(), oldThread.getThreadId());
        if (message.getCategoryId() != 0L && message.getCategoryId() != -1L) {
            MBUtil.updateCategoryThreadCount(category.getCompanyId(), category.getCategoryId());
        }
        indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        indexer.reindex((Object)oldThread);
        indexer.reindex((Object)message.getThread());
        return thread;
    }

    public void updateQuestion(long threadId, boolean question) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        if (thread.isQuestion() == question) {
            return;
        }
        thread.setQuestion(question);
        this.mbThreadPersistence.update((BaseModel)thread);
        if (!question) {
            MBMessage message = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
            this.mbMessageLocalService.updateAnswer(message, false, true);
        }
    }

    public MBThread updateStatus(long userId, long threadId, int status) throws PortalException, SystemException {
        MBCategory category;
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        thread.setModifiedDate(now);
        thread.setStatus(status);
        thread.setStatusByUserId(user.getUserId());
        thread.setStatusByUserName(user.getFullName());
        thread.setStatusDate(now);
        this.mbThreadPersistence.update((BaseModel)thread);
        if (thread.getCategoryId() != 0L && (category = this.mbCategoryPersistence.fetchByPrimaryKey(thread.getCategoryId())) != null) {
            MBUtil.updateCategoryStatistics(category.getCompanyId(), category.getCategoryId());
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        indexer.reindex((Object)thread);
        return thread;
    }

    public MBThread updateThread(long threadId, int viewCount) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        thread.setViewCount(viewCount);
        this.mbThreadPersistence.update((BaseModel)thread);
        return thread;
    }

    protected void moveChildrenMessages(MBMessage parentMessage, MBCategory category, long oldThreadId) throws PortalException, SystemException {
        List messages = this.mbMessagePersistence.findByT_P(oldThreadId, parentMessage.getMessageId());
        for (MBMessage message : messages) {
            message.setCategoryId(parentMessage.getCategoryId());
            message.setThreadId(parentMessage.getThreadId());
            message.setRootMessageId(parentMessage.getRootMessageId());
            this.mbMessagePersistence.update((BaseModel)message);
            if (!message.isDiscussion()) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
                indexer.reindex((Object)message);
            }
            this.moveChildrenMessages(message, category, oldThreadId);
        }
    }
}

