/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.polls.NoSuchVoteException;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.service.PollsChoiceLocalServiceUtil;
import com.liferay.portlet.polls.service.PollsVoteLocalServiceUtil;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class PollsUtil {
    public static CategoryDataset getVotesDataset(long questionId) throws SystemException {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        String seriesName = "";
        for (PollsChoice choice : PollsChoiceLocalServiceUtil.getChoices((long)questionId)) {
            Integer number = choice.getVotesCount();
            defaultCategoryDataset.addValue((Number)number, (Comparable)((Object)seriesName), (Comparable)((Object)choice.getName()));
        }
        return defaultCategoryDataset;
    }

    public static boolean hasVoted(HttpServletRequest request, long questionId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay.isSignedIn()) {
            try {
                PollsVoteLocalServiceUtil.getVote((long)questionId, (long)themeDisplay.getUserId());
            }
            catch (NoSuchVoteException noSuchVoteException) {
                return false;
            }
            return true;
        }
        String cookie = CookieKeys.getCookie((HttpServletRequest)request, (String)PollsUtil._getCookieName(questionId));
        return GetterUtil.getBoolean((String)cookie);
    }

    public static void saveVote(HttpServletRequest request, HttpServletResponse response, long questionId) {
        Cookie cookie = new Cookie(PollsUtil._getCookieName(questionId), "true");
        cookie.setMaxAge(604800);
        cookie.setPath("/");
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)cookie);
    }

    public static void saveVote(PortletRequest portletRequest, PortletResponse portletResponse, long questionId) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
        PollsUtil.saveVote(request, response, questionId);
    }

    private static String _getCookieName(long questionId) {
        return String.valueOf(PollsQuestion.class.getName()) + "#" + questionId;
    }
}

