/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.service.impl;

import com.liferay.portal.TrashPermissionException;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashEntryList;
import com.liferay.portlet.trash.model.TrashEntrySoap;
import com.liferay.portlet.trash.model.impl.TrashEntryImpl;
import com.liferay.portlet.trash.service.base.TrashEntryServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;

public class TrashEntryServiceImpl
extends TrashEntryServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(TrashEntryServiceImpl.class);

    @Transactional(noRollbackFor={TrashPermissionException.class})
    public void deleteEntries(long groupId) throws PortalException, SystemException {
        boolean throwTrashPermissionException = false;
        List entries = this.trashEntryPersistence.findByGroupId(groupId);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        for (TrashEntry entry : entries) {
            try {
                TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entry.getClassName());
                if (!trashHandler.hasTrashPermission(permissionChecker, 0L, entry.getClassPK(), "VIEW")) continue;
                this.deleteEntry(entry);
            }
            catch (TrashPermissionException trashPermissionException) {
                throwTrashPermissionException = true;
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        if (throwTrashPermissionException) {
            throw new TrashPermissionException(2);
        }
    }

    @Transactional(noRollbackFor={TrashPermissionException.class})
    public void deleteEntries(long[] entryIds) throws PortalException, SystemException {
        boolean throwTrashPermissionException = false;
        long[] lArray = entryIds;
        int n = entryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long entryId = lArray[n2];
            try {
                this.deleteEntry(entryId);
            }
            catch (TrashPermissionException trashPermissionException) {
                throwTrashPermissionException = true;
            }
            ++n2;
        }
        if (throwTrashPermissionException) {
            throw new TrashPermissionException(2);
        }
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        TrashEntry entry = this.trashEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public void deleteEntry(String className, long classPK) throws PortalException, SystemException {
        TrashEntry entry = this.trashEntryLocalService.fetchEntry(className, classPK);
        if (entry == null) {
            entry = new TrashEntryImpl();
            entry.setClassName(className);
            entry.setClassPK(classPK);
        }
        this.deleteEntry(entry);
    }

    public TrashEntryList getEntries(long groupId) throws PrincipalException, SystemException {
        return this.getEntries(groupId, -1, -1, null);
    }

    public TrashEntryList getEntries(long groupId, int start, int end, OrderByComparator obc) throws PrincipalException, SystemException {
        TrashEntryList trashEntriesList = new TrashEntryList();
        int entriesCount = this.trashEntryPersistence.countByGroupId(groupId);
        boolean approximate = entriesCount > PropsValues.TRASH_SEARCH_LIMIT;
        trashEntriesList.setApproximate(approximate);
        List entries = this.trashEntryPersistence.findByGroupId(groupId, 0, end + PropsValues.TRASH_SEARCH_LIMIT, obc);
        List<Object> filteredEntries = new ArrayList<TrashEntry>();
        PermissionChecker permissionChecker = this.getPermissionChecker();
        for (TrashEntry entry : entries) {
            String className = entry.getClassName();
            long classPK = entry.getClassPK();
            try {
                TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
                if (!trashHandler.hasTrashPermission(permissionChecker, 0L, classPK, "VIEW")) continue;
                filteredEntries.add(entry);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        int total = filteredEntries.size();
        if (start == -1 && end == -1) {
            start = 0;
            end = total;
        }
        int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd((int)start, (int)end, (int)total);
        start = startAndEnd[0];
        end = startAndEnd[1];
        filteredEntries = filteredEntries.subList(start, end);
        trashEntriesList.setArray(TrashEntrySoap.toSoapModels(filteredEntries));
        trashEntriesList.setCount(total);
        return trashEntriesList;
    }

    public void moveEntry(String className, long classPK, long destinationContainerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        if (!trashHandler.hasTrashPermission(permissionChecker, serviceContext.getScopeGroupId(), destinationContainerModelId, "MOVE")) {
            throw new TrashPermissionException(3);
        }
        if (trashHandler.isInTrash(classPK) && !trashHandler.hasTrashPermission(permissionChecker, 0L, classPK, "RESTORE")) {
            throw new TrashPermissionException(4);
        }
        TrashEntry trashEntry = trashHandler.getTrashEntry(classPK);
        if (trashEntry.isTrashEntry(className, classPK)) {
            trashHandler.checkDuplicateTrashEntry(trashEntry, destinationContainerModelId, "");
        } else {
            trashHandler.checkDuplicateEntry(classPK, destinationContainerModelId, "");
        }
        trashHandler.moveTrashEntry(this.getUserId(), classPK, destinationContainerModelId, serviceContext);
    }

    public TrashEntry restoreEntry(long entryId) throws PortalException, SystemException {
        return this.restoreEntry(entryId, 0L, null);
    }

    public TrashEntry restoreEntry(long entryId, long overrideClassPK, String name) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        TrashEntry entry = this.trashEntryPersistence.findByPrimaryKey(entryId);
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entry.getClassName());
        if (!trashHandler.hasTrashPermission(permissionChecker, 0L, entry.getClassPK(), "RESTORE")) {
            throw new TrashPermissionException(4);
        }
        if (overrideClassPK > 0L) {
            if (!trashHandler.hasTrashPermission(permissionChecker, 0L, overrideClassPK, "OVERWRITE")) {
                throw new TrashPermissionException(5);
            }
            trashHandler.deleteTrashEntry(overrideClassPK);
            trashHandler.checkDuplicateTrashEntry(entry, -1L, null);
        } else if (name != null) {
            if (!trashHandler.hasTrashPermission(permissionChecker, 0L, entry.getClassPK(), "RENAME")) {
                throw new TrashPermissionException(6);
            }
            trashHandler.checkDuplicateTrashEntry(entry, -1L, name);
            trashHandler.updateTitle(entry.getClassPK(), name);
        }
        trashHandler.restoreTrashEntry(this.getUserId(), entry.getClassPK());
        return entry;
    }

    protected void deleteEntry(TrashEntry entry) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entry.getClassName());
        if (!trashHandler.hasTrashPermission(permissionChecker, 0L, entry.getClassPK(), "DELETE")) {
            throw new TrashPermissionException(1);
        }
        trashHandler.deleteTrashEntry(entry.getClassPK());
    }
}

