/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ContactLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.ContactActionableDynamicQuery;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.portlet.PortletURL;

public class ContactIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{Contact.class.getName()};
    public static final String PORTLET_ID = "125";

    public ContactIndexer() {
        this.setStagingAware(false);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "city", false);
        this.addSearchTerm(searchQuery, searchContext, "country", false);
        this.addSearchTerm(searchQuery, searchContext, "emailAddress", false);
        this.addSearchTerm(searchQuery, searchContext, "firstName", false);
        this.addSearchTerm(searchQuery, searchContext, "fullName", false);
        this.addSearchTerm(searchQuery, searchContext, "lastName", false);
        this.addSearchTerm(searchQuery, searchContext, "middleName", false);
        this.addSearchTerm(searchQuery, searchContext, "region", false);
        this.addSearchTerm(searchQuery, searchContext, "screenName", false);
        this.addSearchTerm(searchQuery, searchContext, "street", false);
        this.addSearchTerm(searchQuery, searchContext, "zip", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        Contact contact = (Contact)obj;
        this.deleteDocument(contact.getCompanyId(), contact.getContactId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        User user;
        Contact contact = (Contact)obj;
        if (contact.isUser() && ((user = UserLocalServiceUtil.getUserByContactId((long)contact.getContactId())).isDefaultUser() || user.getStatus() != 0)) {
            return null;
        }
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)contact);
        document.addKeyword("companyId", contact.getCompanyId());
        document.addDate("modified", contact.getModifiedDate());
        document.addKeyword("userId", contact.getUserId());
        document.addKeyword("userName", contact.getFullName());
        document.addText("emailAddress", contact.getEmailAddress());
        document.addText("firstName", contact.getFirstName());
        document.addText("fullName", contact.getFullName());
        document.addText("jobTitle", contact.getJobTitle());
        document.addText("lastName", contact.getLastName());
        document.addText("middleName", contact.getMiddleName());
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("email-address")) {
            return "emailAddress";
        }
        if (orderByCol.equals("first-name")) {
            return "firstName";
        }
        if (orderByCol.equals("job-title")) {
            return "jobTitle";
        }
        if (orderByCol.equals("last-name")) {
            return "lastName";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        return null;
    }

    protected void doReindex(Object obj) throws Exception {
        Contact contact = (Contact)obj;
        Document document = this.getDocument(contact);
        if (document != null) {
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)contact.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        Contact contact = ContactLocalServiceUtil.getContact((long)classPK);
        this.doReindex(contact);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexContacts(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexContacts(long companyId) throws PortalException, SystemException {
        ContactActionableDynamicQuery actionableDynamicQuery = new ContactActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException {
                Contact contact = (Contact)object;
                Document document = ContactIndexer.this.getDocument(contact);
                if (document != null) {
                    this.addDocument(document);
                }
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

