/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.portlet.wiki.DuplicateNodeNameException;
import com.liferay.portlet.wiki.NodeNameException;
import com.liferay.portlet.wiki.importers.WikiImporter;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.base.WikiNodeLocalServiceBaseImpl;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WikiNodeLocalServiceImpl
extends WikiNodeLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(WikiNodeLocalServiceImpl.class);
    private Map<String, WikiImporter> _wikiImporters = new HashMap<String, WikiImporter>();

    public WikiNode addDefaultNode(long userId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addNode(userId, PropsValues.WIKI_INITIAL_NODE_NAME, "", serviceContext);
    }

    public WikiNode addNode(long userId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date now = new Date();
        this.validate(groupId, name);
        long nodeId = this.counterLocalService.increment();
        WikiNode node = this.wikiNodePersistence.create(nodeId);
        node.setUuid(serviceContext.getUuid());
        node.setGroupId(groupId);
        node.setCompanyId(user.getCompanyId());
        node.setUserId(user.getUserId());
        node.setUserName(user.getFullName());
        node.setCreateDate(serviceContext.getCreateDate(now));
        node.setModifiedDate(serviceContext.getModifiedDate(now));
        node.setName(name);
        node.setDescription(description);
        try {
            this.wikiNodePersistence.update((BaseModel)node);
        }
        catch (SystemException se) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Add failed, fetch {groupId=" + groupId + ", name=" + name + "}"));
            }
            if ((node = this.wikiNodePersistence.fetchByG_N(groupId, name, false)) == null) {
                throw se;
            }
            return node;
        }
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addNodeResources(node, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addNodeResources(node, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return node;
    }

    public void addNodeResources(long nodeId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, addGroupPermissions, addGuestPermissions);
    }

    public void addNodeResources(long nodeId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, groupPermissions, guestPermissions);
    }

    public void addNodeResources(WikiNode node, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addNodeResources(WikiNode node, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), groupPermissions, guestPermissions);
    }

    public void deleteNode(long nodeId) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.wikiNodeLocalService.deleteNode(node);
    }

    @SystemEvent(action=1, type=1)
    public void deleteNode(WikiNode node) throws PortalException, SystemException {
        this.wikiPageLocalService.deletePages(node.getNodeId());
        this.wikiNodePersistence.remove((BaseModel)node);
        this.resourceLocalService.deleteResource(node.getCompanyId(), WikiNode.class.getName(), 4, node.getNodeId());
        long folderId = node.getAttachmentsFolderId();
        if (folderId != 0L) {
            PortletFileRepositoryUtil.deleteFolder((long)folderId);
        }
        this.subscriptionLocalService.deleteSubscriptions(node.getCompanyId(), WikiNode.class.getName(), node.getNodeId());
        if (node.isInTrash()) {
            node.setName(TrashUtil.getOriginalTitle((String)node.getName()));
            this.trashEntryLocalService.deleteEntry(WikiNode.class.getName(), node.getNodeId());
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiNode.class);
            indexer.delete((Object)node);
        }
    }

    public void deleteNodes(long groupId) throws PortalException, SystemException {
        List nodes = this.wikiNodePersistence.findByGroupId(groupId);
        for (WikiNode node : nodes) {
            this.wikiNodeLocalService.deleteNode(node);
        }
        PortletFileRepositoryUtil.deletePortletRepository((long)groupId, (String)"36");
    }

    public WikiNode fetchNode(long groupId, String name) throws SystemException {
        return this.wikiNodePersistence.fetchByG_N(groupId, name);
    }

    public WikiNode fetchNodeByUuidAndGroupId(String uuid, long groupId) throws SystemException {
        return this.wikiNodePersistence.fetchByUUID_G(uuid, groupId);
    }

    public List<WikiNode> getCompanyNodes(long companyId, int start, int end) throws SystemException {
        return this.wikiNodePersistence.findByC_S(companyId, 0, start, end);
    }

    public List<WikiNode> getCompanyNodes(long companyId, int status, int start, int end) throws SystemException {
        return this.wikiNodePersistence.findByC_S(companyId, status, start, end);
    }

    public int getCompanyNodesCount(long companyId) throws SystemException {
        return this.wikiNodePersistence.countByC_S(companyId, 0);
    }

    public int getCompanyNodesCount(long companyId, int status) throws SystemException {
        return this.wikiNodePersistence.countByC_S(companyId, status);
    }

    public WikiNode getNode(long nodeId) throws PortalException, SystemException {
        return this.wikiNodePersistence.findByPrimaryKey(nodeId);
    }

    public WikiNode getNode(long groupId, String nodeName) throws PortalException, SystemException {
        return this.wikiNodePersistence.findByG_N(groupId, nodeName);
    }

    public List<WikiNode> getNodes(long groupId) throws PortalException, SystemException {
        return this.getNodes(groupId, 0);
    }

    public List<WikiNode> getNodes(long groupId, int status) throws PortalException, SystemException {
        List<WikiNode> nodes = this.wikiNodePersistence.findByG_S(groupId, status);
        if (nodes.isEmpty()) {
            nodes = this.addDefaultNode(groupId);
        }
        return nodes;
    }

    public List<WikiNode> getNodes(long groupId, int start, int end) throws PortalException, SystemException {
        return this.getNodes(groupId, 0, start, end);
    }

    public List<WikiNode> getNodes(long groupId, int status, int start, int end) throws PortalException, SystemException {
        List<WikiNode> nodes = this.wikiNodePersistence.findByG_S(groupId, status, start, end);
        if (nodes.isEmpty()) {
            nodes = this.addDefaultNode(groupId);
        }
        return nodes;
    }

    public int getNodesCount(long groupId) throws SystemException {
        return this.wikiNodePersistence.countByG_S(groupId, 0);
    }

    public int getNodesCount(long groupId, int status) throws SystemException {
        return this.wikiNodePersistence.countByG_S(groupId, status);
    }

    public void importPages(long userId, long nodeId, String importer, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException, SystemException {
        WikiNode node = this.getNode(nodeId);
        WikiImporter wikiImporter = this.getWikiImporter(importer);
        wikiImporter.importPages(userId, node, inputStreams, options);
    }

    public WikiNode moveNodeToTrash(long userId, long nodeId) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        return this.moveNodeToTrash(userId, node);
    }

    public WikiNode moveNodeToTrash(long userId, WikiNode node) throws PortalException, SystemException {
        int oldStatus = node.getStatus();
        node = this.updateStatus(userId, node, 8, new ServiceContext());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", node.getName());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, node.getGroupId(), WikiNode.class.getName(), node.getNodeId(), node.getUuid(), null, oldStatus, null, typeSettingsProperties);
        node.setName(TrashUtil.getTrashTitle((long)trashEntry.getEntryId()));
        this.wikiNodePersistence.update((BaseModel)node);
        this.moveDependentsToTrash(node.getNodeId(), trashEntry.getEntryId());
        return node;
    }

    public void restoreNodeFromTrash(long userId, WikiNode node) throws PortalException, SystemException {
        node.setName(TrashUtil.getOriginalTitle((String)node.getName()));
        this.wikiNodePersistence.update((BaseModel)node);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(WikiNode.class.getName(), node.getNodeId());
        this.updateStatus(userId, node, trashEntry.getStatus(), new ServiceContext());
        this.restoreDependentFromTrash(node.getNodeId(), trashEntry.getEntryId());
        this.trashEntryLocalService.deleteEntry(trashEntry);
    }

    public void subscribeNode(long userId, long nodeId) throws PortalException, SystemException {
        WikiNode node = this.getNode(nodeId);
        this.subscriptionLocalService.addSubscription(userId, node.getGroupId(), WikiNode.class.getName(), nodeId);
    }

    public void unsubscribeNode(long userId, long nodeId) throws PortalException, SystemException {
        this.subscriptionLocalService.deleteSubscription(userId, WikiNode.class.getName(), nodeId);
    }

    public WikiNode updateNode(long nodeId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.validate(nodeId, node.getGroupId(), name);
        node.setModifiedDate(serviceContext.getModifiedDate(null));
        node.setName(name);
        node.setDescription(description);
        this.wikiNodePersistence.update((BaseModel)node);
        return node;
    }

    public WikiNode updateStatus(long userId, WikiNode node, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        node.setStatus(status);
        node.setStatusByUserId(userId);
        node.setStatusByUserName(user.getFullName());
        node.setStatusDate(now);
        this.wikiNodePersistence.update((BaseModel)node);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiNode.class);
        indexer.reindex((Object)node);
        return node;
    }

    protected List<WikiNode> addDefaultNode(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        WikiNode node = this.wikiNodeLocalService.addDefaultNode(defaultUserId, serviceContext);
        ArrayList<WikiNode> nodes = new ArrayList<WikiNode>(1);
        nodes.add(node);
        return nodes;
    }

    protected WikiImporter getWikiImporter(String importer) throws SystemException {
        WikiImporter wikiImporter = this._wikiImporters.get(importer);
        if (wikiImporter == null) {
            String importerClass = PropsUtil.get("wiki.importers.class", new Filter(importer));
            if (importerClass != null) {
                wikiImporter = (WikiImporter)InstancePool.get((String)importerClass);
                this._wikiImporters.put(importer, wikiImporter);
            }
            if (importer == null) {
                throw new SystemException("Unable to instantiate wiki importer class " + importerClass);
            }
        }
        return wikiImporter;
    }

    protected void moveDependentsToTrash(long nodeId, long trashEntryId) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByNodeId(nodeId);
        for (WikiPage page : pages) {
            int oldStatus = page.getStatus();
            if (oldStatus == 8) continue;
            List versionPages = this.wikiPagePersistence.findByR_N(page.getResourcePrimKey(), page.getNodeId());
            for (WikiPage versionPage : versionPages) {
                int versionPageOldStatus = versionPage.getStatus();
                versionPage.setStatus(8);
                this.wikiPagePersistence.update((BaseModel)versionPage);
                int status = versionPageOldStatus;
                if (versionPageOldStatus == 1) {
                    status = 2;
                }
                if (versionPageOldStatus == 0) continue;
                this.trashVersionLocalService.addTrashVersion(trashEntryId, WikiPage.class.getName(), versionPage.getPageId(), status, null);
            }
            if (oldStatus == 0) {
                this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), false);
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
            indexer.reindex((Object)page);
            if (WikiCacheThreadLocal.isClearCache()) {
                WikiCacheUtil.clearCache(page.getNodeId());
            }
            if (oldStatus != 1) continue;
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(page.getCompanyId(), page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey());
        }
    }

    protected void restoreDependentFromTrash(long nodeId, long trashEntryId) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByN_H(nodeId, true);
        for (WikiPage page : pages) {
            TrashEntry trashEntry = this.trashEntryLocalService.fetchEntry(WikiPage.class.getName(), page.getResourcePrimKey());
            if (trashEntry != null) continue;
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(trashEntryId, WikiPage.class.getName(), page.getPageId());
            int oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            List versionPages = this.wikiPagePersistence.findByR_N(page.getResourcePrimKey(), page.getNodeId());
            for (WikiPage versionPage : versionPages) {
                trashVersion = this.trashVersionLocalService.fetchVersion(trashEntryId, WikiPage.class.getName(), versionPage.getPageId());
                int versionPageOldStatus = 0;
                if (trashVersion != null) {
                    versionPageOldStatus = trashVersion.getStatus();
                }
                versionPage.setStatus(versionPageOldStatus);
                this.wikiPagePersistence.update((BaseModel)versionPage);
                if (trashVersion == null) continue;
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            if (oldStatus == 0) {
                this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), true);
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
            indexer.reindex((Object)page);
        }
    }

    protected void validate(long nodeId, long groupId, String name) throws PortalException, SystemException {
        if (StringUtil.equalsIgnoreCase((String)name, (String)"tag")) {
            throw new NodeNameException(String.valueOf(name) + " is reserved");
        }
        if (Validator.isNull((String)name)) {
            throw new NodeNameException();
        }
        WikiNode node = this.wikiNodePersistence.fetchByG_N(groupId, name);
        if (node != null && node.getNodeId() != nodeId) {
            throw new DuplicateNodeNameException("{nodeId=" + nodeId + "}");
        }
    }

    protected void validate(long groupId, String name) throws PortalException, SystemException {
        this.validate(0L, groupId, name);
    }
}

