/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouterUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.MetaInfoCacheServletResponse;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.login.util.LoginUtil;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LayoutAction
extends Action {
    public static final String[] LAYOUT_RESET_PORTLET_IDS = PropsUtil.getArray("layout.reset.portlet.ids");
    private static Log _log = LogFactoryUtil.getLog(LayoutAction.class);
    private Set<String> _layoutResetPortletIds = new HashSet<String>(Arrays.asList(LAYOUT_RESET_PORTLET_IDS));

    public LayoutAction() {
        this._layoutResetPortletIds.add("");
    }

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MetaInfoCacheServletResponse metaInfoCacheServletResponse = new MetaInfoCacheServletResponse(response);
        try {
            ActionForward actionForward = this.doExecute(actionMapping, actionForm, request, (HttpServletResponse)metaInfoCacheServletResponse);
            return actionForward;
        }
        finally {
            metaInfoCacheServletResponse.finishResponse(false);
        }
    }

    protected ActionForward doExecute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Boolean layoutDefault = (Boolean)request.getAttribute("LAYOUT_DEFAULT");
        if (Boolean.TRUE.equals(layoutDefault)) {
            Layout requestedLayout = (Layout)request.getAttribute("REQUESTED_LAYOUT");
            if (requestedLayout != null) {
                String redirectParam = "redirect";
                if (Validator.isNotNull((String)PropsValues.AUTH_LOGIN_PORTLET_NAME)) {
                    redirectParam = String.valueOf(PortalUtil.getPortletNamespace((String)PropsValues.AUTH_LOGIN_PORTLET_NAME)) + redirectParam;
                }
                String authLoginURL = null;
                if (PrefsPropsUtil.getBoolean(themeDisplay.getCompanyId(), "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED) || PrefsPropsUtil.getBoolean(themeDisplay.getCompanyId(), "open.sso.auth.enabled", PropsValues.OPEN_SSO_AUTH_ENABLED)) {
                    authLoginURL = themeDisplay.getURLSignIn();
                }
                if (Validator.isNull((String)authLoginURL)) {
                    authLoginURL = PortalUtil.getSiteLoginURL((ThemeDisplay)themeDisplay);
                }
                if (Validator.isNull((String)authLoginURL)) {
                    authLoginURL = PropsValues.AUTH_LOGIN_URL;
                }
                if (Validator.isNull((String)authLoginURL)) {
                    PortletURL loginURL = LoginUtil.getLoginURL(request, themeDisplay.getPlid());
                    authLoginURL = loginURL.toString();
                }
                authLoginURL = HttpUtil.setParameter((String)authLoginURL, (String)"p_p_id", (String)PropsValues.AUTH_LOGIN_PORTLET_NAME);
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                authLoginURL = HttpUtil.setParameter((String)authLoginURL, (String)redirectParam, (String)currentURL);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect requested layout to " + authLoginURL));
                }
                response.sendRedirect(authLoginURL);
            } else {
                Layout layout = themeDisplay.getLayout();
                String redirect = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect default layout to " + redirect));
                }
                response.sendRedirect(redirect);
            }
            return null;
        }
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("p_l_id is " + plid));
        }
        if (plid > 0L) {
            Layout layout = themeDisplay.getLayout();
            if (layout != null) {
                plid = layout.getPlid();
            }
            ActionForward actionForward = this.processLayout(actionMapping, request, response, plid);
            return actionForward;
        }
        try {
            this.forwardLayout(request);
            return actionMapping.findForward("/common/forward_jsp.jsp");
        }
        catch (Exception e2) {
            PortalUtil.sendError((Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected void forwardLayout(HttpServletRequest request) throws Exception {
        String forwardURL;
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        long plid = 0L;
        String layoutFriendlyURL = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (layout != null) {
            plid = layout.getPlid();
            layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        }
        if (Validator.isNull(forwardURL = layoutFriendlyURL)) {
            forwardURL = String.valueOf(themeDisplay.getPathMain()) + "/portal/layout?p_l_id=" + plid;
        }
        if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
            forwardURL = HttpUtil.addParameter((String)forwardURL, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
        }
        if (Validator.isNotNull((String)themeDisplay.getDoAsUserLanguageId())) {
            forwardURL = HttpUtil.addParameter((String)forwardURL, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Forward layout to " + forwardURL));
        }
        request.setAttribute("FORWARD_URL", (Object)forwardURL);
    }

    protected void includeLayoutContent(HttpServletRequest request, HttpServletResponse response, ThemeDisplay themeDisplay, Layout layout, String portletId) throws Exception {
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        String path = "/html";
        if (BrowserSnifferUtil.isWap((HttpServletRequest)request)) {
            path = "/wap";
        }
        path = Validator.isNotNull((String)portletId) ? (layout.isTypePanel() ? String.valueOf(path) + "/portal/layout/view/panel.jsp" : (layout.isTypeControlPanel() ? String.valueOf(path) + "/portal/layout/view/control_panel.jsp" : String.valueOf(path) + "/portal/layout/view/portlet.jsp")) : String.valueOf(path) + PortalUtil.getLayoutViewPage((Layout)layout);
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingServletResponse = new PipingServletResponse(response, (Writer)unsyncStringWriter);
        String contentType = pipingServletResponse.getContentType();
        requestDispatcher.include((ServletRequest)request, (ServletResponse)pipingServletResponse);
        if (contentType != null) {
            response.setContentType(contentType);
        }
        request.setAttribute("LAYOUT_CONTENT", (Object)unsyncStringWriter.getStringBundler());
    }

    protected ActionForward processLayout(ActionMapping actionMapping, HttpServletRequest request, HttpServletResponse response, long plid) throws Exception {
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            Layout layout = themeDisplay.getLayout();
            if (layout != null && layout.isTypeURL()) {
                String redirect = PortalUtil.getLayoutActualURL((Layout)layout);
                response.sendRedirect(redirect);
                return null;
            }
            Long previousLayoutPlid = (Long)session.getAttribute("PREVIOUS_LAYOUT_PLID");
            if (previousLayoutPlid == null || layout.getPlid() != previousLayoutPlid.longValue()) {
                session.setAttribute("PREVIOUS_LAYOUT_PLID", (Object)layout.getPlid());
                if (themeDisplay.isSignedIn() && PropsValues.AUDIT_MESSAGE_COM_LIFERAY_PORTAL_MODEL_LAYOUT_VIEW && AuditRouterUtil.isDeployed()) {
                    User user = themeDisplay.getUser();
                    AuditMessage auditMessage = new AuditMessage("VIEW", user.getCompanyId(), user.getUserId(), user.getFullName(), Layout.class.getName(), String.valueOf(layout.getPlid()));
                    AuditRouterUtil.route((AuditMessage)auditMessage);
                }
            }
            boolean resetLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_l_reset", (boolean)PropsValues.LAYOUT_DEFAULT_P_L_RESET);
            String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
            if (resetLayout && (this._layoutResetPortletIds.contains(portletId) || previousLayoutPlid != null && layout.getPlid() != previousLayoutPlid.longValue())) {
                RenderParametersPool.clear(request, plid);
            }
            Portlet portlet = null;
            if (Validator.isNotNull((String)portletId)) {
                long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
                portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
            }
            if (portlet != null) {
                PortletContainerUtil.preparePortlet((HttpServletRequest)request, portlet);
                if (themeDisplay.isLifecycleAction()) {
                    PortletContainerUtil.processAction((HttpServletRequest)request, (HttpServletResponse)response, (Portlet)portlet);
                    if (response.isCommitted()) {
                        return null;
                    }
                } else if (themeDisplay.isLifecycleResource()) {
                    PortletContainerUtil.serveResource((HttpServletRequest)request, (HttpServletResponse)response, (Portlet)portlet);
                    return null;
                }
            }
            if (layout != null) {
                if (themeDisplay.isStateExclusive()) {
                    PortletContainerUtil.render((HttpServletRequest)request, (HttpServletResponse)response, (Portlet)portlet);
                    return null;
                }
                this.includeLayoutContent(request, response, themeDisplay, layout, portletId);
            }
            ActionForward actionForward = actionMapping.findForward("portal.layout");
            return actionForward;
        }
        catch (Exception e2) {
            PortalUtil.sendError((Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
        finally {
            PortletRequest portletRequest;
            if (!ServerDetector.isResin() && (portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request")) != null) {
                PortletRequestImpl portletRequestImpl = PortletRequestImpl.getPortletRequestImpl(portletRequest);
                portletRequestImpl.cleanUp();
            }
        }
    }
}

