/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.captcha.simplecaptcha;

import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.captcha.CaptchaMaxChallengesException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.captcha.Captcha;
import nl.captcha.backgrounds.BackgroundProducer;
import nl.captcha.gimpy.GimpyRenderer;
import nl.captcha.noise.NoiseProducer;
import nl.captcha.servlet.CaptchaServletUtil;
import nl.captcha.text.producer.TextProducer;
import nl.captcha.text.renderer.WordRenderer;

public class SimpleCaptchaImpl
implements com.liferay.portal.kernel.captcha.Captcha {
    private static final String _TAGLIB_PATH = "/html/taglib/ui/captcha/simplecaptcha.jsp";
    private static Log _log = LogFactoryUtil.getLog(SimpleCaptchaImpl.class);
    private BackgroundProducer[] _backgroundProducers;
    private GimpyRenderer[] _gimpyRenderers;
    private NoiseProducer[] _noiseProducers;
    private TextProducer[] _textProducers;
    private WordRenderer[] _wordRenderers;

    public SimpleCaptchaImpl() {
        this.initBackgroundProducers();
        this.initGimpyRenderers();
        this.initNoiseProducers();
        this.initTextProducers();
        this.initWordRenderers();
    }

    public void check(HttpServletRequest request) throws CaptchaException {
        if (!this.isEnabled(request)) {
            return;
        }
        if (!this.validateChallenge(request)) {
            this.incrementCounter(request);
            this.checkMaxChallenges(request);
            throw new CaptchaTextException();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"CAPTCHA text is valid");
        }
    }

    public void check(PortletRequest portletRequest) throws CaptchaException {
        if (!this.isEnabled(portletRequest)) {
            return;
        }
        if (!this.validateChallenge(portletRequest)) {
            this.incrementCounter(portletRequest);
            this.checkMaxChallenges(portletRequest);
            throw new CaptchaTextException();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"CAPTCHA text is valid");
        }
    }

    public String getTaglibPath() {
        return _TAGLIB_PATH;
    }

    public boolean isEnabled(HttpServletRequest request) throws CaptchaException {
        this.checkMaxChallenges(request);
        return PropsValues.CAPTCHA_MAX_CHALLENGES >= 0;
    }

    public boolean isEnabled(PortletRequest portletRequest) throws CaptchaException {
        this.checkMaxChallenges(portletRequest);
        return PropsValues.CAPTCHA_MAX_CHALLENGES >= 0;
    }

    public void serveImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        Captcha simpleCaptcha = this.getSimpleCaptcha();
        session.setAttribute("CAPTCHA_TEXT", (Object)simpleCaptcha.getAnswer());
        response.setContentType("image/png");
        CaptchaServletUtil.writeImage((OutputStream)response.getOutputStream(), (BufferedImage)simpleCaptcha.getImage());
    }

    public void serveImage(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        PortletSession portletSession = resourceRequest.getPortletSession();
        Captcha simpleCaptcha = this.getSimpleCaptcha();
        portletSession.setAttribute("CAPTCHA_TEXT", (Object)simpleCaptcha.getAnswer());
        resourceResponse.setContentType("image/png");
        CaptchaServletUtil.writeImage((OutputStream)resourceResponse.getPortletOutputStream(), (BufferedImage)simpleCaptcha.getImage());
    }

    protected void checkMaxChallenges(HttpServletRequest request) throws CaptchaMaxChallengesException {
        if (PropsValues.CAPTCHA_MAX_CHALLENGES > 0) {
            HttpSession session = request.getSession();
            Integer count = (Integer)session.getAttribute("CAPTCHA_COUNT");
            this.checkMaxChallenges(count);
        }
    }

    protected void checkMaxChallenges(Integer count) throws CaptchaMaxChallengesException {
        if (count != null && count > PropsValues.CAPTCHA_MAX_CHALLENGES) {
            throw new CaptchaMaxChallengesException();
        }
    }

    protected void checkMaxChallenges(PortletRequest portletRequest) throws CaptchaMaxChallengesException {
        if (PropsValues.CAPTCHA_MAX_CHALLENGES > 0) {
            PortletSession portletSession = portletRequest.getPortletSession();
            Integer count = (Integer)portletSession.getAttribute("CAPTCHA_COUNT");
            this.checkMaxChallenges(count);
        }
    }

    protected BackgroundProducer getBackgroundProducer() {
        if (this._backgroundProducers.length == 1) {
            return this._backgroundProducers[0];
        }
        int pos = RandomUtil.nextInt((int)this._backgroundProducers.length);
        return this._backgroundProducers[pos];
    }

    protected GimpyRenderer getGimpyRenderer() {
        if (this._gimpyRenderers.length == 1) {
            return this._gimpyRenderers[0];
        }
        int pos = RandomUtil.nextInt((int)this._gimpyRenderers.length);
        return this._gimpyRenderers[pos];
    }

    protected int getHeight() {
        return PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_HEIGHT;
    }

    protected NoiseProducer getNoiseProducer() {
        if (this._noiseProducers.length == 1) {
            return this._noiseProducers[0];
        }
        int pos = RandomUtil.nextInt((int)this._noiseProducers.length);
        return this._noiseProducers[pos];
    }

    protected Captcha getSimpleCaptcha() {
        Captcha.Builder captchaBuilder = new Captcha.Builder(this.getWidth(), this.getHeight());
        captchaBuilder.addText(this.getTextProducer(), this.getWordRenderer());
        captchaBuilder.addBackground(this.getBackgroundProducer());
        captchaBuilder.gimp(this.getGimpyRenderer());
        captchaBuilder.addNoise(this.getNoiseProducer());
        captchaBuilder.addBorder();
        return captchaBuilder.build();
    }

    protected TextProducer getTextProducer() {
        if (this._textProducers.length == 1) {
            return this._textProducers[0];
        }
        int pos = RandomUtil.nextInt((int)this._textProducers.length);
        return this._textProducers[pos];
    }

    protected int getWidth() {
        return PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_WIDTH;
    }

    protected WordRenderer getWordRenderer() {
        if (this._wordRenderers.length == 1) {
            return this._wordRenderers[0];
        }
        int pos = RandomUtil.nextInt((int)this._wordRenderers.length);
        return this._wordRenderers[pos];
    }

    protected void incrementCounter(HttpServletRequest request) {
        if (PropsValues.CAPTCHA_MAX_CHALLENGES > 0 && Validator.isNotNull((String)request.getRemoteUser())) {
            HttpSession session = request.getSession();
            Integer count = (Integer)session.getAttribute("CAPTCHA_COUNT");
            session.setAttribute("CAPTCHA_COUNT", (Object)this.incrementCounter(count));
        }
    }

    protected Integer incrementCounter(Integer count) {
        count = count == null ? new Integer(1) : new Integer(count + 1);
        return count;
    }

    protected void incrementCounter(PortletRequest portletRequest) {
        if (PropsValues.CAPTCHA_MAX_CHALLENGES > 0 && Validator.isNotNull((String)portletRequest.getRemoteUser())) {
            PortletSession portletSession = portletRequest.getPortletSession();
            Integer count = (Integer)portletSession.getAttribute("CAPTCHA_COUNT");
            portletSession.setAttribute("CAPTCHA_COUNT", (Object)this.incrementCounter(count));
        }
    }

    protected void initBackgroundProducers() {
        String[] backgroundProducerClassNames = PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_BACKGROUND_PRODUCERS;
        this._backgroundProducers = new BackgroundProducer[backgroundProducerClassNames.length];
        int i2 = 0;
        while (i2 < backgroundProducerClassNames.length) {
            String backgroundProducerClassName = backgroundProducerClassNames[i2];
            this._backgroundProducers[i2] = (BackgroundProducer)InstancePool.get((String)backgroundProducerClassName);
            ++i2;
        }
    }

    protected void initGimpyRenderers() {
        String[] gimpyRendererClassNames = PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_GIMPY_RENDERERS;
        this._gimpyRenderers = new GimpyRenderer[gimpyRendererClassNames.length];
        int i2 = 0;
        while (i2 < gimpyRendererClassNames.length) {
            String gimpyRendererClassName = gimpyRendererClassNames[i2];
            this._gimpyRenderers[i2] = (GimpyRenderer)InstancePool.get((String)gimpyRendererClassName);
            ++i2;
        }
    }

    protected void initNoiseProducers() {
        String[] noiseProducerClassNames = PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_NOISE_PRODUCERS;
        this._noiseProducers = new NoiseProducer[noiseProducerClassNames.length];
        int i2 = 0;
        while (i2 < noiseProducerClassNames.length) {
            String noiseProducerClassName = noiseProducerClassNames[i2];
            this._noiseProducers[i2] = (NoiseProducer)InstancePool.get((String)noiseProducerClassName);
            ++i2;
        }
    }

    protected void initTextProducers() {
        String[] textProducerClassNames = PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_TEXT_PRODUCERS;
        this._textProducers = new TextProducer[textProducerClassNames.length];
        int i2 = 0;
        while (i2 < textProducerClassNames.length) {
            String textProducerClassName = textProducerClassNames[i2];
            this._textProducers[i2] = (TextProducer)InstancePool.get((String)textProducerClassName);
            ++i2;
        }
    }

    protected void initWordRenderers() {
        String[] wordRendererClassNames = PropsValues.CAPTCHA_ENGINE_SIMPLECAPTCHA_WORD_RENDERERS;
        this._wordRenderers = new WordRenderer[wordRendererClassNames.length];
        int i2 = 0;
        while (i2 < wordRendererClassNames.length) {
            String wordRendererClassName = wordRendererClassNames[i2];
            this._wordRenderers[i2] = (WordRenderer)InstancePool.get((String)wordRendererClassName);
            ++i2;
        }
    }

    protected boolean validateChallenge(HttpServletRequest request) throws CaptchaException {
        HttpSession session = request.getSession();
        String captchaText = (String)session.getAttribute("CAPTCHA_TEXT");
        if (request instanceof UploadPortletRequest) {
            UploadPortletRequest uploadPortletRequest = (UploadPortletRequest)request;
            PortletRequest portletRequest = uploadPortletRequest.getPortletRequest();
            PortletSession portletSession = portletRequest.getPortletSession();
            captchaText = (String)portletSession.getAttribute("CAPTCHA_TEXT");
        }
        if (captchaText == null) {
            _log.error((Object)("CAPTCHA text is null. User " + request.getRemoteUser() + " may be trying to circumvent the CAPTCHA."));
            throw new CaptchaTextException();
        }
        boolean valid = captchaText.equals(ParamUtil.getString((HttpServletRequest)request, (String)"captchaText"));
        if (valid) {
            if (request instanceof UploadPortletRequest) {
                UploadPortletRequest uploadPortletRequest = (UploadPortletRequest)request;
                PortletRequest portletRequest = uploadPortletRequest.getPortletRequest();
                PortletSession portletSession = portletRequest.getPortletSession();
                portletSession.removeAttribute("CAPTCHA_TEXT");
            } else {
                session.removeAttribute("CAPTCHA_TEXT");
            }
        }
        return valid;
    }

    protected boolean validateChallenge(PortletRequest portletRequest) throws CaptchaException {
        PortletSession portletSession = portletRequest.getPortletSession();
        String captchaText = (String)portletSession.getAttribute("CAPTCHA_TEXT");
        if (captchaText == null) {
            _log.error((Object)("CAPTCHA text is null. User " + portletRequest.getRemoteUser() + " may be trying to circumvent the CAPTCHA."));
            throw new CaptchaTextException();
        }
        boolean valid = captchaText.equals(ParamUtil.getString((PortletRequest)portletRequest, (String)"captchaText"));
        if (valid) {
            portletSession.removeAttribute("CAPTCHA_TEXT");
        }
        return valid;
    }
}

