/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard.advice;

import com.liferay.portal.dao.shard.advice.ShardAdvice;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.model.Portlet;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ShardPortletAdvice
implements MethodInterceptor {
    private static Log _log = LogFactoryUtil.getLog(ShardPortletAdvice.class);
    private ShardAdvice _shardAdvice;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        String methodName = method.getName();
        Object[] arguments = methodInvocation.getArguments();
        if (ArrayUtil.isEmpty((Object[])arguments)) {
            return methodInvocation.proceed();
        }
        Object argument = arguments[0];
        long companyId = -1L;
        if (argument instanceof Long) {
            if (methodName.equals("checkPortlets") || methodName.equals("clonePortlet") || methodName.equals("getPortletById") || methodName.equals("getPortletByStrutsPath") || methodName.equals("getPortlets") || methodName.equals("hasPortlet") || methodName.equals("loadGetPortletsPool") || methodName.equals("updatePortlet")) {
                companyId = (Long)argument;
            }
        } else if (argument instanceof Portlet && (methodName.equals("checkPortlet") || methodName.equals("deployRemotePortlet") || methodName.equals("destroyPortlet") || methodName.equals("destroyRemotePortlet"))) {
            Portlet portlet = (Portlet)argument;
            companyId = portlet.getCompanyId();
        }
        if (companyId <= 0L) {
            return methodInvocation.proceed();
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Setting company service to shard of companyId " + companyId + " for " + methodInvocation.toString()));
        }
        Object returnValue = null;
        this._shardAdvice.pushCompanyService(companyId);
        try {
            returnValue = methodInvocation.proceed();
        }
        finally {
            this._shardAdvice.popCompanyService();
        }
        return returnValue;
    }

    public void setShardAdvice(ShardAdvice shardAdvice) {
        this._shardAdvice = shardAdvice;
    }
}

