/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.im;

import com.liferay.portal.im.MSNMessageAdapter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsUtil;
import rath.msnm.MSNMessenger;
import rath.msnm.event.MsnListener;

public class MSNConnector {
    private static Log _log = LogFactoryUtil.getLog(MSNConnector.class);
    private static MSNConnector _instance = new MSNConnector();
    private String _login = PropsUtil.get("msn.login");
    private MSNMessenger _msn;
    private String _password = PropsUtil.get("msn.password");

    public static void disconnect() {
        if (_instance != null) {
            _instance._disconnect();
        }
    }

    public static void send(String to, String msg) {
        _instance._send(to, msg);
    }

    private MSNConnector() {
        this._msn = new MSNMessenger(this._login, this._password);
        this._msn.setInitialStatus("NLN");
    }

    private void _connect() {
        if (this._msn.isLoggedIn()) {
            return;
        }
        this._msn.login();
        int i2 = 0;
        while (i2 < 50 && !this._msn.isLoggedIn()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                if (!_log.isWarnEnabled()) break;
                _log.warn((Throwable)ie);
                break;
            }
            ++i2;
        }
        if (!this._msn.isLoggedIn()) {
            _log.error((Object)("Unable to connect as " + this._login));
        }
    }

    private void _disconnect() {
        block3: {
            try {
                if (this._msn.isLoggedIn()) {
                    this._msn.logout();
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled() || !_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)e2);
            }
        }
    }

    private void _send(String to, String msg) {
        block2: {
            this._connect();
            this._msn.addMsnListener((MsnListener)new MSNMessageAdapter(this._msn, to, msg));
            try {
                Thread.sleep(1500L);
                this._msn.doCallWait(to);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)e2);
            }
        }
    }
}

