/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.MethodParametersResolverUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;

public class JSONWebServiceActionConfig
implements Comparable<JSONWebServiceActionConfig>,
JSONWebServiceActionMapping {
    private Class<?> _actionClass;
    private Method _actionMethod;
    private Object _actionObject;
    private String _contextPath;
    private String _fullPath;
    private String _method;
    private MethodParameter[] _methodParameters;
    private String _path;
    private String _signature;

    public JSONWebServiceActionConfig(String contextPath, Class<?> actionClass, Method actionMethod, String path, String method) {
        this._contextPath = contextPath;
        this._actionClass = actionClass;
        this._actionMethod = actionMethod;
        this._path = path;
        this._method = method;
        this._methodParameters = MethodParametersResolverUtil.resolveMethodParameters((Method)actionMethod);
        this._fullPath = String.valueOf(this._contextPath) + this._path;
        StringBundler sb = new StringBundler(this._methodParameters.length * 2 + 4);
        sb.append(this._fullPath);
        sb.append('-');
        sb.append(this._methodParameters.length);
        MethodParameter[] methodParameterArray = this._methodParameters;
        int n = this._methodParameters.length;
        int n2 = 0;
        while (n2 < n) {
            MethodParameter methodParameter = methodParameterArray[n2];
            sb.append('-');
            sb.append(methodParameter.getName());
            ++n2;
        }
        this._signature = sb.toString();
    }

    public JSONWebServiceActionConfig(String contextPath, Object actionObject, Class<?> actionClass, Method actionMethod, String path, String method) {
        this(contextPath, actionClass, actionMethod, path, method);
        this._actionObject = actionObject;
        try {
            Method actionObjectClassActionMethod;
            Class<?> actionObjectClass = actionObject.getClass();
            this._actionMethod = actionObjectClassActionMethod = actionObjectClass.getMethod(actionMethod.getName(), actionMethod.getParameterTypes());
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException(nsme);
        }
    }

    @Override
    public int compareTo(JSONWebServiceActionConfig jsonWebServiceActionConfig) {
        return this._signature.compareTo(jsonWebServiceActionConfig._signature);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JSONWebServiceActionConfig)) {
            return false;
        }
        JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)object;
        return Validator.equals((Object)this._signature, (Object)jsonWebServiceActionConfig._signature);
    }

    public Class<?> getActionClass() {
        return this._actionClass;
    }

    public Method getActionMethod() {
        return this._actionMethod;
    }

    public Object getActionObject() {
        return this._actionObject;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getFullPath() {
        return this._fullPath;
    }

    public String getMethod() {
        return this._method;
    }

    public MethodParameter[] getMethodParameters() {
        return this._methodParameters;
    }

    public String getPath() {
        return this._path;
    }

    public String getSignature() {
        return this._signature;
    }

    public int hashCode() {
        return this._signature.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler(17);
        sb.append("{actionClass=");
        sb.append(this._actionClass);
        sb.append(", actionMethod=");
        sb.append((Object)this._actionMethod);
        sb.append(", contextPath=");
        sb.append(this._contextPath);
        sb.append(", fullPath=");
        sb.append(this._fullPath);
        sb.append(", method=");
        sb.append(this._method);
        sb.append(", methodParameters=");
        sb.append((Object)this._methodParameters);
        sb.append(", path=");
        sb.append(this._path);
        sb.append(", signature=");
        sb.append(this._signature);
        sb.append("}");
        return sb.toString();
    }
}

