/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.jsonwebservice.JSONRPCResponse;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionConfig;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionParameters;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.service.ServiceContext;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jodd.bean.BeanCopy;
import jodd.bean.BeanUtil;
import jodd.typeconverter.TypeConverterManager;
import jodd.util.NameValue;
import jodd.util.ReflectUtil;

public class JSONWebServiceActionImpl
implements JSONWebServiceAction {
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceActionImpl.class);
    private JSONWebServiceActionConfig _jsonWebServiceActionConfig;
    private JSONWebServiceActionParameters _jsonWebServiceActionParameters;

    public JSONWebServiceActionImpl(JSONWebServiceActionConfig jsonWebServiceActionConfig, JSONWebServiceActionParameters jsonWebServiceActionParameters) {
        this._jsonWebServiceActionConfig = jsonWebServiceActionConfig;
        this._jsonWebServiceActionParameters = jsonWebServiceActionParameters;
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping() {
        return this._jsonWebServiceActionConfig;
    }

    public Object invoke() throws Exception {
        JSONRPCRequest jsonRPCRequest = this._jsonWebServiceActionParameters.getJSONRPCRequest();
        if (jsonRPCRequest == null) {
            return this._invokeActionMethod();
        }
        Object result = null;
        Exception exception = null;
        try {
            result = this._invokeActionMethod();
        }
        catch (Exception e2) {
            exception = e2;
            _log.error((Object)e2, (Throwable)e2);
        }
        return new JSONRPCResponse(jsonRPCRequest, result, exception);
    }

    private Object _convertListToArray(List<?> list, Class<?> componentType) {
        Object array = Array.newInstance(componentType, list.size());
        int i2 = 0;
        while (i2 < list.size()) {
            Object entry = list.get(i2);
            if (entry != null) {
                entry = TypeConverterManager.convertType(entry, componentType);
            }
            Array.set(array, i2, entry);
            ++i2;
        }
        return array;
    }

    private Object _convertValueToParameterValue(Object value, Class<?> parameterType, Class<?>[] genericParameterTypes) {
        if (parameterType.isArray()) {
            List list = null;
            if (value instanceof List) {
                list = (List)value;
            } else {
                String valueString = value.toString();
                if (!(valueString = valueString.trim()).startsWith("[")) {
                    valueString = "[".concat(valueString).concat("]");
                }
                list = (List)JSONFactoryUtil.looseDeserializeSafe((String)valueString, ArrayList.class);
            }
            return this._convertListToArray(list, parameterType.getComponentType());
        }
        if (parameterType.equals(Calendar.class)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            String valueString = value.toString();
            valueString = valueString.trim();
            long timeInMillis = GetterUtil.getLong((String)valueString);
            calendar.setTimeInMillis(timeInMillis);
            return calendar;
        }
        if (Collection.class.isAssignableFrom(parameterType)) {
            List list = null;
            if (value instanceof List) {
                list = (List)value;
            } else {
                String valueString = value.toString();
                if (!(valueString = valueString.trim()).startsWith("[")) {
                    valueString = "[".concat(valueString).concat("]");
                }
                list = (List)JSONFactoryUtil.looseDeserializeSafe((String)valueString, ArrayList.class);
            }
            return this._generifyList(list, genericParameterTypes);
        }
        if (parameterType.equals(Locale.class)) {
            String valueString = value.toString();
            valueString = valueString.trim();
            return LocaleUtil.fromLanguageId((String)valueString);
        }
        if (parameterType.equals(Map.class)) {
            Map map = null;
            if (value instanceof Map) {
                map = (Map)value;
            } else {
                String valueString = value.toString();
                valueString = valueString.trim();
                map = (Map)JSONFactoryUtil.looseDeserializeSafe((String)valueString, HashMap.class);
            }
            return this._generifyMap(map, genericParameterTypes);
        }
        Object parameterValue = null;
        try {
            parameterValue = TypeConverterManager.convertType((Object)value, parameterType);
        }
        catch (Exception e1) {
            if (value instanceof Map) {
                try {
                    parameterValue = this._createDefaultParameterValue(null, parameterType);
                }
                catch (Exception exception) {
                    throw new ClassCastException(e1.getMessage());
                }
                BeanCopy beanCopy = BeanCopy.beans((Object)value, (Object)parameterValue);
                beanCopy.copy();
            }
            String valueString = value.toString();
            if (!(valueString = valueString.trim()).startsWith("{")) {
                throw new ClassCastException(e1.getMessage());
            }
            parameterValue = JSONFactoryUtil.looseDeserializeSafe((String)valueString, parameterType);
        }
        return parameterValue;
    }

    private Object _createDefaultParameterValue(String parameterName, Class<?> parameterType) throws Exception {
        if (parameterName != null && parameterName.equals("serviceContext") && parameterType.equals(ServiceContext.class)) {
            ServiceContext serviceContext = this._jsonWebServiceActionParameters.getServiceContext();
            if (serviceContext == null) {
                serviceContext = new ServiceContext();
            }
            return serviceContext;
        }
        String className = parameterType.getName();
        if (className.contains("com.liferay") && className.contains("Util")) {
            throw new IllegalArgumentException("Not instantiating " + className);
        }
        return parameterType.newInstance();
    }

    private List<?> _generifyList(List<?> list, Class<?>[] types) {
        if (types == null) {
            return list;
        }
        if (types.length != 1) {
            return list;
        }
        ArrayList newList = new ArrayList(list.size());
        for (Object entry : list) {
            if (entry != null) {
                entry = TypeConverterManager.convertType(entry, types[0]);
            }
            newList.add(entry);
        }
        return newList;
    }

    private Map<?, ?> _generifyMap(Map<?, ?> map, Class<?>[] types) {
        if (types == null) {
            return map;
        }
        if (types.length != 2) {
            return map;
        }
        HashMap newMap = new HashMap(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = TypeConverterManager.convertType(entry.getKey(), types[0]);
            Object value = entry.getValue();
            if (value != null) {
                value = TypeConverterManager.convertType(value, types[1]);
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    private void _injectInnerParametersIntoValue(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            return;
        }
        List<NameValue<String, Object>> innerParameters = this._jsonWebServiceActionParameters.getInnerParameters(parameterName);
        if (innerParameters == null) {
            return;
        }
        for (NameValue<String, Object> innerParameter : innerParameters) {
            try {
                BeanUtil.setProperty((Object)parameterValue, (String)((String)innerParameter.getName()), (Object)innerParameter.getValue());
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to set inner parameter " + parameterName + "." + (String)innerParameter.getName()), (Throwable)e2);
            }
        }
    }

    private Object _invokeActionMethod() throws Exception {
        Object actionObject = this._jsonWebServiceActionConfig.getActionObject();
        Method actionMethod = this._jsonWebServiceActionConfig.getActionMethod();
        Class<?> actionClass = this._jsonWebServiceActionConfig.getActionClass();
        Object[] parameters = this._prepareParameters(actionClass);
        return actionMethod.invoke(actionObject, parameters);
    }

    private Object[] _prepareParameters(Class<?> actionClass) throws Exception {
        MethodParameter[] methodParameters = this._jsonWebServiceActionConfig.getMethodParameters();
        Object[] parameters = new Object[methodParameters.length];
        int i2 = 0;
        while (i2 < methodParameters.length) {
            String parameterName = methodParameters[i2].getName();
            parameterName = CamelCaseUtil.normalizeCamelCase((String)parameterName);
            Object value = this._jsonWebServiceActionParameters.getParameter(parameterName);
            Object parameterValue = null;
            if (value != null) {
                ClassLoader classLoader;
                Class<?> parameterType = methodParameters[i2].getType();
                String parameterTypeName = this._jsonWebServiceActionParameters.getParameterTypeName(parameterName);
                if (parameterTypeName != null && !ReflectUtil.isSubclass(parameterType = (classLoader = actionClass.getClassLoader()).loadClass(parameterTypeName), (Class)methodParameters[i2].getType())) {
                    throw new IllegalArgumentException("Unmatched argument type " + parameterType.getName() + " for method argument " + i2);
                }
                if (value.equals(Void.TYPE)) {
                    parameterValue = this._createDefaultParameterValue(parameterName, parameterType);
                } else {
                    parameterValue = this._convertValueToParameterValue(value, parameterType, methodParameters[i2].getGenericTypes());
                    ServiceContext serviceContext = this._jsonWebServiceActionParameters.getServiceContext();
                    if (serviceContext != null && parameterName.equals("serviceContext")) {
                        if (parameterValue != null && ServiceContext.class.isAssignableFrom(parameterValue.getClass())) {
                            serviceContext.merge((ServiceContext)parameterValue);
                        }
                        parameterValue = serviceContext;
                    }
                }
            }
            this._injectInnerParametersIntoValue(parameterName, parameterValue);
            parameters[i2] = parameterValue;
            ++i2;
        }
        return parameters;
    }
}

