/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.User;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.persistence.JournalArticleActionableDynamicQuery;
import com.liferay.portlet.journal.util.JournalArticleIndexer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StagingIndexingBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    private static Log _log = LogFactoryUtil.getLog(StagingIndexingBackgroundTaskExecutor.class);

    public StagingIndexingBackgroundTaskExecutor() {
        this.setSerial(true);
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        long userId;
        Map taskContextMap = backgroundTask.getTaskContextMap();
        PortletDataContext portletDataContext = (PortletDataContext)taskContextMap.get("portletDataContext");
        boolean importPermissions = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS");
        if (importPermissions && (userId = MapUtil.getLong((Map)taskContextMap, (String)"userId")) > 0L) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)userId);
        }
        Map newPrimaryKeysMaps = portletDataContext.getNewPrimaryKeysMaps();
        for (Map.Entry newPrimaryKeysMapsEntry : newPrimaryKeysMaps.entrySet()) {
            String className = (String)newPrimaryKeysMapsEntry.getKey();
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)className);
            if (indexer == null && !className.equals(DDMStructure.class.getName())) continue;
            Map newPrimaryKeysMap = (Map)newPrimaryKeysMapsEntry.getValue();
            ArrayList<Long> newPrimaryKeys = new ArrayList<Long>();
            for (Object object : newPrimaryKeysMap.values()) {
                long classPK = GetterUtil.getLong(object);
                if (classPK <= 0L) continue;
                newPrimaryKeys.add(classPK);
            }
            if (className.equals(DDMStructure.class.getName())) {
                this.reindexDDMStructures(newPrimaryKeys, newPrimaryKeysMaps, portletDataContext.getGroupId());
                continue;
            }
            for (Long classPK : newPrimaryKeys) {
                indexer.reindex(className, classPK.longValue());
            }
        }
        return BackgroundTaskResult.SUCCESS;
    }

    protected ActionableDynamicQuery getJournalArticleActionableDynamicQuery(long groupId, final Map<?, ?> journalArticleIds, final String[] ddmStructureKeys) throws Exception {
        JournalArticleActionableDynamicQuery journalArticleActionableDynamicQuery = new JournalArticleActionableDynamicQuery(){
            private final JournalArticleIndexer _journalArticleIndexer = (JournalArticleIndexer)IndexerRegistryUtil.getIndexer(JournalArticle.class);

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property structureIdProperty = PropertyFactoryUtil.forName((String)"structureId");
                dynamicQuery.add(structureIdProperty.in((Object[])ddmStructureKeys));
            }

            protected void performAction(Object object) throws PortalException {
                JournalArticle article = (JournalArticle)object;
                if (StagingIndexingBackgroundTaskExecutor.this.containsValue(journalArticleIds, article.getResourcePrimKey())) {
                    return;
                }
                try {
                    this._journalArticleIndexer.doReindex(article, false);
                }
                catch (Exception e2) {
                    throw new PortalException((Throwable)e2);
                }
            }
        };
        journalArticleActionableDynamicQuery.setGroupId(groupId);
        return journalArticleActionableDynamicQuery;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void reindexDDMStructures(List<Long> ddmStructureIds, Map<String, Map<?, ?>> newPrimaryKeysMaps, long groupId) throws Exception {
        block6: {
            if (ddmStructureIds == null || ddmStructureIds.isEmpty()) {
                return;
            }
            ddmStructureKeys = new String[ddmStructureIds.size()];
            i = 0;
            while (i < ddmStructureIds.size()) {
                structureId = ddmStructureIds.get(i);
                ddmStructure = DDMStructureLocalServiceUtil.getDDMStructure((long)structureId);
                ddmStructureKeys[i] = ddmStructure.getStructureKey();
                ++i;
            }
            articleIds = newPrimaryKeysMaps.get(JournalArticle.class.getName());
            journalArticleActionableDynamicQuery = this.getJournalArticleActionableDynamicQuery(groupId, articleIds, ddmStructureKeys);
            journalArticleActionableDynamicQuery.performActions();
            dlFileEntries /* !! */  = new ArrayList<DLFileEntry>();
            try {
                method = ReflectionUtil.getDeclaredMethod(DLFileEntryLocalServiceUtil.class, (String)"getDDMStructureFileEntries", (Class[])new Class[]{Long.TYPE, long[].class});
                object = method.invoke(DLFileEntryLocalServiceUtil.class, new Object[]{groupId, ArrayUtil.toLongArray(ddmStructureIds)});
                if (object == null) break block6;
                dlFileEntries /* !! */  = (List)object;
                break block6;
            }
            catch (Exception v0) {
                allDlFileEntries = DLFileEntryLocalServiceUtil.getDDMStructureFileEntries((long[])ArrayUtil.toLongArray(ddmStructureIds));
                ** for (dlFileEntry : allDlFileEntries)
            }
lbl-1000:
            // 1 sources

            {
                if (groupId != dlFileEntry.getGroupId()) continue;
                dlFileEntries /* !! */ .add(dlFileEntry);
                continue;
            }
        }
        dlFileEntryPrimaryKeysMap = newPrimaryKeysMaps.get(DLFileEntry.class.getName());
        dlFileEntryIndexer = IndexerRegistryUtil.getIndexer(DLFileEntry.class);
        for (DLFileEntry dlFileEntry : dlFileEntries /* !! */ ) {
            if (this.containsValue(dlFileEntryPrimaryKeysMap, dlFileEntry.getFileEntryId())) continue;
            dlFileEntryIndexer.reindex((Object)dlFileEntry);
        }
    }

    protected boolean containsValue(Map<?, ?> map, long value) {
        if (map == null || map.isEmpty() || value <= 0L) {
            return false;
        }
        for (Object object : map.values()) {
            if (GetterUtil.getLong(object) != value) continue;
            return true;
        }
        return false;
    }

    public String handleException(BackgroundTask backgroundTask, Exception e2) {
        StringBundler sb = new StringBundler(4);
        sb.append("Indexing failed after importing with the following error: ");
        sb.append(e2.getMessage());
        sb.append(".");
        sb.append(" ");
        sb.append("Please reindex site manually.");
        String message = sb.toString();
        if (_log.isInfoEnabled()) {
            _log.info((Object)message);
        }
        return message;
    }
}

