/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.PluginSetting;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.PluginSettingBaseImpl;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;

public class PluginSettingImpl
extends PluginSettingBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(PluginSettingImpl.class);
    private String[] _rolesArray;

    public PluginSettingImpl() {
    }

    public PluginSettingImpl(PluginSetting pluginSetting) {
        this.setCompanyId(pluginSetting.getCompanyId());
        this.setPluginId(pluginSetting.getPluginId());
        this.setPluginType(pluginSetting.getPluginType());
        this.setRoles(pluginSetting.getRoles());
        this.setActive(pluginSetting.getActive());
    }

    public void addRole(String role) {
        this.setRolesArray((String[])ArrayUtil.append((Object[])this._rolesArray, (Object)role));
    }

    public String[] getRolesArray() {
        return this._rolesArray;
    }

    public boolean hasPermission(long userId) {
        block8: {
            block7: {
                block6: {
                    if (this._rolesArray.length != 0) break block6;
                    return true;
                }
                if (!RoleLocalServiceUtil.hasUserRoles((long)userId, (long)this.getCompanyId(), (String[])this._rolesArray, (boolean)true)) break block7;
                return true;
            }
            if (!RoleLocalServiceUtil.hasUserRole((long)userId, (long)this.getCompanyId(), (String)"Administrator", (boolean)true)) break block8;
            return true;
        }
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            if (user.isDefaultUser() && this.hasRoleWithName("Guest")) {
                return true;
            }
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return false;
    }

    public boolean hasRoleWithName(String roleName) {
        int i2 = 0;
        while (i2 < this._rolesArray.length) {
            if (StringUtil.equalsIgnoreCase((String)this._rolesArray[i2], (String)roleName)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public void setRoles(String roles) {
        this._rolesArray = StringUtil.split((String)roles);
        super.setRoles(roles);
    }

    public void setRolesArray(String[] rolesArray) {
        this._rolesArray = rolesArray;
        super.setRoles(StringUtil.merge((Object[])rolesArray));
    }
}

