/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.TeamModel;
import com.liferay.portal.model.TeamSoap;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.model.impl.TeamCacheModel;
import com.liferay.portal.model.impl.TeamImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JSON(strict=true)
public class TeamModelImpl
extends BaseModelImpl<Team>
implements TeamModel {
    public static final String TABLE_NAME = "Team";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"teamId", -5}, {"companyId", -5}, {"userId", -5}, {"userName", 12}, {"createDate", 93}, {"modifiedDate", 93}, {"groupId", -5}, {"name", 12}, {"description", 12}};
    public static final String TABLE_SQL_CREATE = "create table Team (teamId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,groupId LONG,name VARCHAR(75) null,description STRING null)";
    public static final String TABLE_SQL_DROP = "drop table Team";
    public static final String ORDER_BY_JPQL = " ORDER BY team.name ASC";
    public static final String ORDER_BY_SQL = " ORDER BY Team.name ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.entity.cache.enabled.com.liferay.portal.model.Team"), (boolean)true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.finder.cache.enabled.com.liferay.portal.model.Team"), (boolean)true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.column.bitmask.enabled.com.liferay.portal.model.Team"), (boolean)true);
    public static long GROUPID_COLUMN_BITMASK = 1L;
    public static long NAME_COLUMN_BITMASK = 2L;
    public static final String MAPPING_TABLE_USERS_TEAMS_NAME = "Users_Teams";
    public static final Object[][] MAPPING_TABLE_USERS_TEAMS_COLUMNS = new Object[][]{{"userId", -5}, {"teamId", -5}};
    public static final String MAPPING_TABLE_USERS_TEAMS_SQL_CREATE = "create table Users_Teams (teamId LONG not null,userId LONG not null,primary key (teamId, userId))";
    public static final boolean FINDER_CACHE_ENABLED_USERS_TEAMS = GetterUtil.getBoolean((String)PropsUtil.get("value.object.finder.cache.enabled.Users_Teams"), (boolean)true);
    public static final String MAPPING_TABLE_USERGROUPS_TEAMS_NAME = "UserGroups_Teams";
    public static final Object[][] MAPPING_TABLE_USERGROUPS_TEAMS_COLUMNS = new Object[][]{{"userGroupId", -5}, {"teamId", -5}};
    public static final String MAPPING_TABLE_USERGROUPS_TEAMS_SQL_CREATE = "create table UserGroups_Teams (teamId LONG not null,userGroupId LONG not null,primary key (teamId, userGroupId))";
    public static final boolean FINDER_CACHE_ENABLED_USERGROUPS_TEAMS = GetterUtil.getBoolean((String)PropsUtil.get("value.object.finder.cache.enabled.UserGroups_Teams"), (boolean)true);
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong((String)PropsUtil.get("lock.expiration.time.com.liferay.portal.model.Team"));
    private static ClassLoader _classLoader = Team.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[]{Team.class};
    private long _teamId;
    private long _companyId;
    private long _userId;
    private String _userUuid;
    private String _userName;
    private Date _createDate;
    private Date _modifiedDate;
    private long _groupId;
    private long _originalGroupId;
    private boolean _setOriginalGroupId;
    private String _name;
    private String _originalName;
    private String _description;
    private long _columnBitmask;
    private Team _escapedModel;

    public static Team toModel(TeamSoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        TeamImpl model = new TeamImpl();
        model.setTeamId(soapModel.getTeamId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setUserId(soapModel.getUserId());
        model.setUserName(soapModel.getUserName());
        model.setCreateDate(soapModel.getCreateDate());
        model.setModifiedDate(soapModel.getModifiedDate());
        model.setGroupId(soapModel.getGroupId());
        model.setName(soapModel.getName());
        model.setDescription(soapModel.getDescription());
        return model;
    }

    public static List<Team> toModels(TeamSoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<Team> models = new ArrayList<Team>(soapModels.length);
        TeamSoap[] teamSoapArray = soapModels;
        int n = soapModels.length;
        int n2 = 0;
        while (n2 < n) {
            TeamSoap soapModel = teamSoapArray[n2];
            models.add(TeamModelImpl.toModel(soapModel));
            ++n2;
        }
        return models;
    }

    public long getPrimaryKey() {
        return this._teamId;
    }

    public void setPrimaryKey(long primaryKey) {
        this.setTeamId(primaryKey);
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this._teamId);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public Class<?> getModelClass() {
        return Team.class;
    }

    public String getModelClassName() {
        return Team.class.getName();
    }

    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("teamId", this.getTeamId());
        attributes.put("companyId", this.getCompanyId());
        attributes.put("userId", this.getUserId());
        attributes.put("userName", this.getUserName());
        attributes.put("createDate", this.getCreateDate());
        attributes.put("modifiedDate", this.getModifiedDate());
        attributes.put("groupId", this.getGroupId());
        attributes.put("name", this.getName());
        attributes.put("description", this.getDescription());
        return attributes;
    }

    public void setModelAttributes(Map<String, Object> attributes) {
        String description;
        String name;
        Long groupId;
        Date modifiedDate;
        Date createDate;
        String userName;
        Long userId;
        Long companyId;
        Long teamId = (Long)attributes.get("teamId");
        if (teamId != null) {
            this.setTeamId(teamId);
        }
        if ((companyId = (Long)attributes.get("companyId")) != null) {
            this.setCompanyId(companyId);
        }
        if ((userId = (Long)attributes.get("userId")) != null) {
            this.setUserId(userId);
        }
        if ((userName = (String)attributes.get("userName")) != null) {
            this.setUserName(userName);
        }
        if ((createDate = (Date)attributes.get("createDate")) != null) {
            this.setCreateDate(createDate);
        }
        if ((modifiedDate = (Date)attributes.get("modifiedDate")) != null) {
            this.setModifiedDate(modifiedDate);
        }
        if ((groupId = (Long)attributes.get("groupId")) != null) {
            this.setGroupId(groupId);
        }
        if ((name = (String)attributes.get("name")) != null) {
            this.setName(name);
        }
        if ((description = (String)attributes.get("description")) != null) {
            this.setDescription(description);
        }
    }

    @JSON
    public long getTeamId() {
        return this._teamId;
    }

    public void setTeamId(long teamId) {
        this._teamId = teamId;
    }

    @JSON
    public long getCompanyId() {
        return this._companyId;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    @JSON
    public long getUserId() {
        return this._userId;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue((long)this.getUserId(), (String)"uuid", (String)this._userUuid);
    }

    public void setUserUuid(String userUuid) {
        this._userUuid = userUuid;
    }

    @JSON
    public String getUserName() {
        if (this._userName == null) {
            return "";
        }
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    @JSON
    public Date getCreateDate() {
        return this._createDate;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    @JSON
    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._modifiedDate = modifiedDate;
    }

    @JSON
    public long getGroupId() {
        return this._groupId;
    }

    public void setGroupId(long groupId) {
        this._columnBitmask |= GROUPID_COLUMN_BITMASK;
        if (!this._setOriginalGroupId) {
            this._setOriginalGroupId = true;
            this._originalGroupId = this._groupId;
        }
        this._groupId = groupId;
    }

    public long getOriginalGroupId() {
        return this._originalGroupId;
    }

    @JSON
    public String getName() {
        if (this._name == null) {
            return "";
        }
        return this._name;
    }

    public void setName(String name) {
        this._columnBitmask = -1L;
        if (this._originalName == null) {
            this._originalName = this._name;
        }
        this._name = name;
    }

    public String getOriginalName() {
        return GetterUtil.getString((String)this._originalName);
    }

    @JSON
    public String getDescription() {
        if (this._description == null) {
            return "";
        }
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)Team.class.getName(), (long)this.getPrimaryKey());
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
    }

    public Team toEscapedModel() {
        if (this._escapedModel == null) {
            this._escapedModel = (Team)ProxyUtil.newProxyInstance((ClassLoader)_classLoader, (Class[])_escapedModelInterfaces, (InvocationHandler)new AutoEscapeBeanHandler((Object)this));
        }
        return this._escapedModel;
    }

    public Object clone() {
        TeamImpl teamImpl = new TeamImpl();
        teamImpl.setTeamId(this.getTeamId());
        teamImpl.setCompanyId(this.getCompanyId());
        teamImpl.setUserId(this.getUserId());
        teamImpl.setUserName(this.getUserName());
        teamImpl.setCreateDate(this.getCreateDate());
        teamImpl.setModifiedDate(this.getModifiedDate());
        teamImpl.setGroupId(this.getGroupId());
        teamImpl.setName(this.getName());
        teamImpl.setDescription(this.getDescription());
        teamImpl.resetOriginalValues();
        return teamImpl;
    }

    public int compareTo(Team team) {
        int value = 0;
        value = this.getName().compareTo(team.getName());
        if (value != 0) {
            return value;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Team)) {
            return false;
        }
        Team team = (Team)obj;
        long primaryKey = team.getPrimaryKey();
        return this.getPrimaryKey() == primaryKey;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    public void resetOriginalValues() {
        TeamModelImpl teamModelImpl = this;
        teamModelImpl._originalGroupId = teamModelImpl._groupId;
        teamModelImpl._setOriginalGroupId = false;
        teamModelImpl._originalName = teamModelImpl._name;
        teamModelImpl._columnBitmask = 0L;
    }

    public CacheModel<Team> toCacheModel() {
        String description;
        Date createDate;
        TeamCacheModel teamCacheModel = new TeamCacheModel();
        teamCacheModel.teamId = this.getTeamId();
        teamCacheModel.companyId = this.getCompanyId();
        teamCacheModel.userId = this.getUserId();
        teamCacheModel.userName = this.getUserName();
        String userName = teamCacheModel.userName;
        if (userName != null && userName.length() == 0) {
            teamCacheModel.userName = null;
        }
        teamCacheModel.createDate = (createDate = this.getCreateDate()) != null ? createDate.getTime() : Long.MIN_VALUE;
        Date modifiedDate = this.getModifiedDate();
        teamCacheModel.modifiedDate = modifiedDate != null ? modifiedDate.getTime() : Long.MIN_VALUE;
        teamCacheModel.groupId = this.getGroupId();
        teamCacheModel.name = this.getName();
        String name = teamCacheModel.name;
        if (name != null && name.length() == 0) {
            teamCacheModel.name = null;
        }
        if ((description = (teamCacheModel.description = this.getDescription())) != null && description.length() == 0) {
            teamCacheModel.description = null;
        }
        return teamCacheModel;
    }

    public String toString() {
        StringBundler sb = new StringBundler(19);
        sb.append("{teamId=");
        sb.append(this.getTeamId());
        sb.append(", companyId=");
        sb.append(this.getCompanyId());
        sb.append(", userId=");
        sb.append(this.getUserId());
        sb.append(", userName=");
        sb.append(this.getUserName());
        sb.append(", createDate=");
        sb.append((Object)this.getCreateDate());
        sb.append(", modifiedDate=");
        sb.append((Object)this.getModifiedDate());
        sb.append(", groupId=");
        sb.append(this.getGroupId());
        sb.append(", name=");
        sb.append(this.getName());
        sb.append(", description=");
        sb.append(this.getDescription());
        sb.append("}");
        return sb.toString();
    }

    public String toXmlString() {
        StringBundler sb = new StringBundler(31);
        sb.append("<model><model-name>");
        sb.append("com.liferay.portal.model.Team");
        sb.append("</model-name>");
        sb.append("<column><column-name>teamId</column-name><column-value><![CDATA[");
        sb.append(this.getTeamId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>companyId</column-name><column-value><![CDATA[");
        sb.append(this.getCompanyId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(this.getUserId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userName</column-name><column-value><![CDATA[");
        sb.append(this.getUserName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>createDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getCreateDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getModifiedDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(this.getGroupId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>name</column-name><column-value><![CDATA[");
        sb.append(this.getName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>description</column-name><column-value><![CDATA[");
        sb.append(this.getDescription());
        sb.append("]]></column-value></column>");
        sb.append("</model>");
        return sb.toString();
    }
}

