/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.DummyIndexer;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.spring.aop.ServiceBeanAopCacheManagerUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IndexerRegistryImpl
implements IndexerRegistry {
    private static Log _log = LogFactoryUtil.getLog(IndexerRegistryImpl.class);
    private Indexer _dummyIndexer = new DummyIndexer();
    private Map<String, Indexer> _indexers = new ConcurrentHashMap<String, Indexer>();

    public Indexer getIndexer(String className) {
        return this._indexers.get(className);
    }

    public List<Indexer> getIndexers() {
        return ListUtil.fromMapValues(this._indexers);
    }

    public Indexer nullSafeGetIndexer(String className) {
        Indexer indexer = this._indexers.get(className);
        if (indexer != null) {
            return indexer;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("No indexer found for " + className));
        }
        return this._dummyIndexer;
    }

    public void register(String className, Indexer indexerInstance) {
        this._indexers.put(className, indexerInstance);
        ServiceBeanAopCacheManagerUtil.reset();
    }

    public void unregister(String className) {
        this._indexers.remove(className);
    }
}

