/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class TransientTokenUtil {
    private static final ConcurrentNavigableMap<Long, String> _tokens = new ConcurrentSkipListMap<Long, String>();

    public static boolean checkToken(String token) {
        long currentTime = System.currentTimeMillis();
        TransientTokenUtil._expungeExpiredToken(currentTime);
        Set tokens = _tokens.entrySet();
        Iterator itr = tokens.iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String curToken = (String)entry.getValue();
            if (!token.equals(curToken)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public static void clearAll() {
        _tokens.clear();
    }

    public static String createToken(long timeTolive) {
        long currentTime = System.currentTimeMillis();
        long expireTime = currentTime + timeTolive;
        TransientTokenUtil._expungeExpiredToken(currentTime);
        String token = PortalUUIDUtil.generate();
        while (_tokens.putIfAbsent(expireTime, token) != null) {
            ++expireTime;
        }
        return token;
    }

    private static void _expungeExpiredToken(long currentTime) {
        SortedMap headMap = _tokens.headMap((Object)currentTime);
        headMap.clear();
    }
}

