/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.LayoutSetBranchNameException;
import com.liferay.portal.NoSuchLayoutSetBranchException;
import com.liferay.portal.RequiredLayoutSetBranchException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutSetBranchLocalServiceBaseImpl;
import com.liferay.portal.util.comparator.LayoutSetBranchCreateDateComparator;
import java.text.Format;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class LayoutSetBranchLocalServiceImpl
extends LayoutSetBranchLocalServiceBaseImpl {
    public LayoutSetBranch addLayoutSetBranch(long userId, long groupId, boolean privateLayout, String name, String description, boolean master, long copyLayoutSetBranchId, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(0L, groupId, privateLayout, name, master);
        boolean logo = false;
        long logoId = 0L;
        String themeId = null;
        String colorSchemeId = null;
        String wapThemeId = null;
        String wapColorSchemeId = null;
        String css = null;
        String settings = null;
        if (copyLayoutSetBranchId > 0L) {
            LayoutSetBranch copyLayoutSetBranch = this.getLayoutSetBranch(copyLayoutSetBranchId);
            logo = copyLayoutSetBranch.getLogo();
            logoId = copyLayoutSetBranch.getLogoId();
            themeId = copyLayoutSetBranch.getThemeId();
            colorSchemeId = copyLayoutSetBranch.getColorSchemeId();
            wapThemeId = copyLayoutSetBranch.getWapThemeId();
            wapColorSchemeId = copyLayoutSetBranch.getWapColorSchemeId();
            css = copyLayoutSetBranch.getCss();
            settings = copyLayoutSetBranch.getSettings();
        } else {
            LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayout);
            logo = layoutSet.getLogo();
            logoId = layoutSet.getLogoId();
            themeId = layoutSet.getThemeId();
            colorSchemeId = layoutSet.getColorSchemeId();
            wapThemeId = layoutSet.getWapThemeId();
            wapColorSchemeId = layoutSet.getWapColorSchemeId();
            css = layoutSet.getCss();
            settings = layoutSet.getSettings();
        }
        long layoutSetBranchId = this.counterLocalService.increment();
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.create(layoutSetBranchId);
        layoutSetBranch.setGroupId(groupId);
        layoutSetBranch.setCompanyId(user.getCompanyId());
        layoutSetBranch.setUserId(user.getUserId());
        layoutSetBranch.setUserName(user.getFullName());
        layoutSetBranch.setCreateDate(serviceContext.getCreateDate(now));
        layoutSetBranch.setModifiedDate(serviceContext.getModifiedDate(now));
        layoutSetBranch.setPrivateLayout(privateLayout);
        layoutSetBranch.setName(name);
        layoutSetBranch.setDescription(description);
        layoutSetBranch.setMaster(master);
        layoutSetBranch.setLogo(logo);
        layoutSetBranch.setLogoId(logoId);
        if (logo) {
            Image logoImage = this.imageLocalService.getImage(logoId);
            long layoutSetBranchLogoId = this.counterLocalService.increment();
            this.imageLocalService.updateImage(layoutSetBranchLogoId, logoImage.getTextObj(), logoImage.getType(), logoImage.getHeight(), logoImage.getWidth(), logoImage.getSize());
            layoutSetBranch.setLogoId(layoutSetBranchLogoId);
        }
        layoutSetBranch.setThemeId(themeId);
        layoutSetBranch.setColorSchemeId(colorSchemeId);
        layoutSetBranch.setWapThemeId(wapThemeId);
        layoutSetBranch.setWapColorSchemeId(wapColorSchemeId);
        layoutSetBranch.setCss(css);
        layoutSetBranch.setSettings(settings);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        this.resourceLocalService.addResources(user.getCompanyId(), layoutSetBranch.getGroupId(), user.getUserId(), LayoutSetBranch.class.getName(), layoutSetBranch.getLayoutSetBranchId(), false, true, false);
        if (layoutSetBranch.isMaster() || copyLayoutSetBranchId == 0L) {
            List layouts = this.layoutPersistence.findByG_P(layoutSetBranch.getGroupId(), layoutSetBranch.getPrivateLayout());
            for (Layout layout : layouts) {
                LayoutBranch layoutBranch = this.layoutBranchLocalService.addLayoutBranch(layoutSetBranchId, layout.getPlid(), "main-variation", "", true, serviceContext);
                LayoutRevision lastLayoutRevision = this.layoutRevisionLocalService.fetchLastLayoutRevision(layout.getPlid(), true);
                if (lastLayoutRevision != null) {
                    this.layoutRevisionLocalService.addLayoutRevision(userId, layoutSetBranchId, layoutBranch.getLayoutBranchId(), 0L, true, lastLayoutRevision.getPlid(), lastLayoutRevision.getLayoutRevisionId(), lastLayoutRevision.getPrivateLayout(), lastLayoutRevision.getName(), lastLayoutRevision.getTitle(), lastLayoutRevision.getDescription(), lastLayoutRevision.getKeywords(), lastLayoutRevision.getRobots(), lastLayoutRevision.getTypeSettings(), lastLayoutRevision.isIconImage(), lastLayoutRevision.getIconImageId(), lastLayoutRevision.getThemeId(), lastLayoutRevision.getColorSchemeId(), lastLayoutRevision.getWapThemeId(), lastLayoutRevision.getWapColorSchemeId(), lastLayoutRevision.getCss(), serviceContext);
                    continue;
                }
                this.layoutRevisionLocalService.addLayoutRevision(userId, layoutSetBranchId, layoutBranch.getLayoutBranchId(), 0L, false, layout.getPlid(), 0L, layout.getPrivateLayout(), layout.getName(), layout.getTitle(), layout.getDescription(), layout.getKeywords(), layout.getRobots(), layout.getTypeSettings(), layout.isIconImage(), layout.getIconImageId(), layout.getThemeId(), layout.getColorSchemeId(), layout.getWapThemeId(), layout.getWapColorSchemeId(), layout.getCss(), serviceContext);
            }
        } else if (copyLayoutSetBranchId > 0L) {
            List layoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(copyLayoutSetBranchId, true);
            for (LayoutRevision layoutRevision : layoutRevisions) {
                LayoutBranch layoutBranch = this.layoutBranchLocalService.addLayoutBranch(layoutSetBranchId, layoutRevision.getPlid(), "main-variation", "", true, serviceContext);
                this.layoutRevisionLocalService.addLayoutRevision(userId, layoutSetBranchId, layoutBranch.getLayoutBranchId(), 0L, true, layoutRevision.getPlid(), layoutRevision.getLayoutRevisionId(), layoutRevision.getPrivateLayout(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.isIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getWapThemeId(), layoutRevision.getWapColorSchemeId(), layoutRevision.getCss(), serviceContext);
            }
        }
        LayoutSet layoutSet = layoutSetBranch.getLayoutSet();
        StagingUtil.setRecentLayoutSetBranchId((User)user, (long)layoutSet.getLayoutSetId(), (long)layoutSetBranch.getLayoutSetBranchId());
        return layoutSetBranch;
    }

    @Override
    public LayoutSetBranch deleteLayoutSetBranch(LayoutSetBranch layoutSetBranch) throws PortalException, SystemException {
        return this.deleteLayoutSetBranch(layoutSetBranch, false);
    }

    public LayoutSetBranch deleteLayoutSetBranch(LayoutSetBranch layoutSetBranch, boolean includeMaster) throws PortalException, SystemException {
        if (!includeMaster && layoutSetBranch.isMaster()) {
            throw new RequiredLayoutSetBranchException();
        }
        this.layoutSetBranchPersistence.remove((BaseModel)layoutSetBranch);
        this.resourceLocalService.deleteResource(layoutSetBranch.getCompanyId(), LayoutSetBranch.class.getName(), 4, layoutSetBranch.getLayoutSetBranchId());
        this.layoutBranchLocalService.deleteLayoutSetBranchLayoutBranches(layoutSetBranch.getLayoutSetBranchId());
        this.layoutRevisionLocalService.deleteLayoutSetBranchLayoutRevisions(layoutSetBranch.getLayoutSetBranchId());
        return layoutSetBranch;
    }

    @Override
    public LayoutSetBranch deleteLayoutSetBranch(long layoutSetBranchId) throws PortalException, SystemException {
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutSetBranchId);
        return this.deleteLayoutSetBranch(layoutSetBranch, false);
    }

    public void deleteLayoutSetBranches(long groupId, boolean privateLayout) throws PortalException, SystemException {
        this.deleteLayoutSetBranches(groupId, privateLayout, false);
    }

    public void deleteLayoutSetBranches(long groupId, boolean privateLayout, boolean includeMaster) throws PortalException, SystemException {
        List layoutSetBranches = this.layoutSetBranchPersistence.findByG_P(groupId, privateLayout);
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            this.deleteLayoutSetBranch(layoutSetBranch, includeMaster);
        }
    }

    public LayoutSetBranch fetchLayoutSetBranch(long groupId, boolean privateLayout, String name) throws SystemException {
        return this.layoutSetBranchPersistence.fetchByG_P_N(groupId, privateLayout, name);
    }

    public LayoutSetBranch getLayoutSetBranch(long groupId, boolean privateLayout, String name) throws PortalException, SystemException {
        return this.layoutSetBranchPersistence.findByG_P_N(groupId, privateLayout, name);
    }

    public List<LayoutSetBranch> getLayoutSetBranches(long groupId, boolean privateLayout) throws SystemException {
        return this.layoutSetBranchPersistence.findByG_P(groupId, privateLayout, -1, -1, (OrderByComparator)new LayoutSetBranchCreateDateComparator(true));
    }

    public LayoutSetBranch getMasterLayoutSetBranch(long groupId, boolean privateLayout) throws PortalException, SystemException {
        return this.layoutSetBranchPersistence.findByG_P_M_First(groupId, privateLayout, true, null);
    }

    public LayoutSetBranch getUserLayoutSetBranch(long userId, long groupId, boolean privateLayout, long layoutSetBranchId) throws PortalException, SystemException {
        return this.getUserLayoutSetBranch(userId, groupId, privateLayout, 0L, layoutSetBranchId);
    }

    public LayoutSetBranch getUserLayoutSetBranch(long userId, long groupId, boolean privateLayout, long layoutSetId, long layoutSetBranchId) throws PortalException, SystemException {
        LayoutSetBranch layoutSetBranch;
        if (layoutSetBranchId <= 0L) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            if (layoutSetId <= 0L) {
                LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayout);
                layoutSetId = layoutSet.getLayoutSetId();
            }
            layoutSetBranchId = StagingUtil.getRecentLayoutSetBranchId((User)user, (long)layoutSetId);
        }
        if (layoutSetBranchId > 0L && (layoutSetBranch = this.fetchLayoutSetBranch(layoutSetBranchId)) != null) {
            return layoutSetBranch;
        }
        return this.getMasterLayoutSetBranch(groupId, privateLayout);
    }

    public LayoutSetBranch mergeLayoutSetBranch(long layoutSetBranchId, long mergeLayoutSetBranchId, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutSetBranchId);
        LayoutSetBranch mergeLayoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(mergeLayoutSetBranchId);
        Locale locale = serviceContext.getLocale();
        Format dateFormatDateTime = FastDateFormatFactoryUtil.getDateTime((Locale)locale);
        String nowString = dateFormatDateTime.format(new Date());
        serviceContext.setWorkflowAction(2);
        List layoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(mergeLayoutSetBranchId, true);
        for (LayoutRevision layoutRevision : layoutRevisions) {
            String layoutBranchName = this.getLayoutBranchName(layoutSetBranch.getLayoutSetBranchId(), locale, layoutRevision.getLayoutBranch().getName(), mergeLayoutSetBranch.getName(), layoutRevision.getPlid());
            StringBundler sb = new StringBundler(3);
            sb.append(mergeLayoutSetBranch.getDescription());
            sb.append(" ");
            sb.append(LanguageUtil.format((Locale)locale, (String)"merged-from-x-x", (Object[])new String[]{mergeLayoutSetBranch.getName(), nowString}));
            LayoutBranch layoutBranch = this.layoutBranchLocalService.addLayoutBranch(layoutSetBranch.getLayoutSetBranchId(), layoutRevision.getPlid(), layoutBranchName, sb.toString(), false, serviceContext);
            this.layoutRevisionLocalService.addLayoutRevision(layoutRevision.getUserId(), layoutSetBranch.getLayoutSetBranchId(), layoutBranch.getLayoutBranchId(), 0L, false, layoutRevision.getPlid(), layoutRevision.getLayoutRevisionId(), layoutRevision.isPrivateLayout(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getWapThemeId(), layoutRevision.getWapColorSchemeId(), layoutRevision.getCss(), serviceContext);
        }
        return layoutSetBranch;
    }

    public LayoutSetBranch updateLayoutSetBranch(long layoutSetBranchId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutSetBranchId);
        this.validate(layoutSetBranch.getLayoutSetBranchId(), layoutSetBranch.getGroupId(), layoutSetBranch.getPrivateLayout(), name, layoutSetBranch.isMaster());
        layoutSetBranch.setName(name);
        layoutSetBranch.setDescription(description);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        return layoutSetBranch;
    }

    protected String getLayoutBranchName(long layoutSetBranchId, Locale locale, String mergeBranchName, String mergeLayoutSetBranchName, long plid) throws SystemException {
        LayoutBranch layoutBranch = this.layoutBranchPersistence.fetchByL_P_N(layoutSetBranchId, plid, mergeBranchName);
        if (layoutBranch == null) {
            return mergeBranchName;
        }
        StringBundler sb = new StringBundler(5);
        sb.append(LanguageUtil.get((Locale)locale, (String)mergeBranchName));
        sb.append(" ");
        sb.append("(");
        sb.append(LanguageUtil.get((Locale)locale, (String)mergeLayoutSetBranchName));
        sb.append(")");
        String layoutBranchName = sb.toString();
        int i2 = 1;
        while ((layoutBranch = this.layoutBranchPersistence.fetchByL_P_N(layoutSetBranchId, plid, layoutBranchName)) != null) {
            layoutBranchName = String.valueOf(sb.toString()) + " " + i2;
            ++i2;
        }
        return layoutBranchName;
    }

    protected void validate(long layoutSetBranchId, long groupId, boolean privateLayout, String name, boolean master) throws PortalException, SystemException {
        if (Validator.isNull((String)name) || name.length() < 4) {
            throw new LayoutSetBranchNameException(3);
        }
        if (name.length() > 100) {
            throw new LayoutSetBranchNameException(2);
        }
        try {
            LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByG_P_N(groupId, privateLayout, name);
            if (layoutSetBranch.getLayoutSetBranchId() != layoutSetBranchId) {
                throw new LayoutSetBranchNameException(1);
            }
        }
        catch (NoSuchLayoutSetBranchException noSuchLayoutSetBranchException) {}
        if (master) {
            try {
                LayoutSetBranch masterLayoutSetBranch = this.layoutSetBranchPersistence.findByG_P_M_First(groupId, privateLayout, true, null);
                if (layoutSetBranchId != masterLayoutSetBranch.getLayoutSetBranchId()) {
                    throw new LayoutSetBranchNameException(4);
                }
            }
            catch (NoSuchLayoutSetBranchException noSuchLayoutSetBranchException) {}
        }
    }
}

