/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.DateFormatFactory;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.util.PortalSimpleDateFormat;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

@DoPrivileged
public class DateFormatFactoryImpl
implements DateFormatFactory {
    public DateFormat getDate(Locale locale) {
        return this.getDate(locale, null);
    }

    public DateFormat getDate(Locale locale, TimeZone timeZone) {
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public DateFormat getDate(TimeZone timeZone) {
        return this.getDate(LocaleUtil.getDefault(), timeZone);
    }

    public DateFormat getDateTime(Locale locale) {
        return this.getDateTime(locale, null);
    }

    public DateFormat getDateTime(Locale locale, TimeZone timeZone) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, locale);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public DateFormat getDateTime(TimeZone timeZone) {
        return this.getDateTime(LocaleUtil.getDefault(), timeZone);
    }

    public DateFormat getSimpleDateFormat(String pattern) {
        return this.getSimpleDateFormat(pattern, LocaleUtil.getDefault(), null);
    }

    public DateFormat getSimpleDateFormat(String pattern, Locale locale) {
        return this.getSimpleDateFormat(pattern, locale, null);
    }

    public DateFormat getSimpleDateFormat(String pattern, Locale locale, TimeZone timeZone) {
        PortalSimpleDateFormat dateFormat = new PortalSimpleDateFormat(pattern, locale);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public DateFormat getSimpleDateFormat(String pattern, TimeZone timeZone) {
        return this.getSimpleDateFormat(pattern, LocaleUtil.getDefault(), timeZone);
    }

    public DateFormat getTime(Locale locale) {
        return this.getTime(locale, null);
    }

    public DateFormat getTime(Locale locale, TimeZone timeZone) {
        DateFormat dateFormat = DateFormat.getTimeInstance(3, locale);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public DateFormat getTime(TimeZone timeZone) {
        return this.getTime(LocaleUtil.getDefault(), timeZone);
    }
}

