/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class VerifyProperties
extends VerifyProcess {
    private static final String[] _LDAP_KEYS = new String[]{"ldap.contact.custom.mappings", "ldap.contact.mappings", "ldap.user.custom.mappings"};
    private static final String[][] _MIGRATED_PORTAL_KEYS = new String[][]{{"cookie.http.only.names.excludes", "cookie.http.only.names.excludes"}, {"finalize.manager.thread.enabled", "com.liferay.portal.kernel.memory.FinalizeManager.thread.enabled"}, {"http.header.secure.x.content.type.options", "http.header.secure.x.content.type.options"}, {"http.header.secure.x.content.type.options.urls.excludes", "http.header.secure.x.content.type.options.urls.excludes"}, {"http.header.secure.x.frame.options", "http.header.secure.x.frame.options"}, {"http.header.secure.x.frame.options.255", "http.header.secure.x.frame.options.255"}, {"http.header.secure.x.xss.protection", "http.header.secure.x.xss.protection"}};
    private static final String[][] _MIGRATED_SYSTEM_KEYS = new String[][]{{"com.liferay.filters.compression.CompressionFilter", "com.liferay.portal.servlet.filters.gzip.GZipFilter"}, {"com.liferay.filters.strip.StripFilter", "com.liferay.portal.servlet.filters.strip.StripFilter"}, {"com.liferay.util.Http.max.connections.per.host", "com.liferay.portal.util.HttpImpl.max.connections.per.host"}, {"com.liferay.util.Http.max.total.connections", "com.liferay.portal.util.HttpImpl.max.total.connections"}, {"com.liferay.util.Http.proxy.auth.type", "com.liferay.portal.util.HttpImpl.proxy.auth.type"}, {"com.liferay.util.Http.proxy.ntlm.domain", "com.liferay.portal.util.HttpImpl.proxy.ntlm.domain"}, {"com.liferay.util.Http.proxy.ntlm.host", "com.liferay.portal.util.HttpImpl.proxy.ntlm.host"}, {"com.liferay.util.Http.proxy.password", "com.liferay.portal.util.HttpImpl.proxy.password"}, {"com.liferay.util.Http.proxy.username", "com.liferay.portal.util.HttpImpl.proxy.username"}, {"com.liferay.util.Http.timeout", "com.liferay.portal.util.HttpImpl.timeout"}, {"com.liferay.util.format.PhoneNumberFormat", "phone.number.format.impl"}, {"com.liferay.util.servlet.UploadServletRequest.max.size", "com.liferay.portal.upload.UploadServletRequestImpl.max.size"}, {"com.liferay.util.servlet.UploadServletRequest.temp.dir", "com.liferay.portal.upload.UploadServletRequestImpl.temp.dir"}, {"com.liferay.util.servlet.fileupload.LiferayFileItem.threshold.size", "com.liferay.portal.upload.LiferayFileItem.threshold.size"}, {"com.liferay.util.servlet.fileupload.LiferayInputStream.threshold.size", "com.liferay.portal.upload.LiferayInputStream.threshold.size"}};
    private static final String[] _OBSOLETE_PORTAL_KEYS = new String[]{"asset.entry.increment.view.counter.enabled", "auth.max.failures.limit", "buffered.increment.parallel.queue.size", "buffered.increment.serial.queue.size", "cas.validate.url", "cluster.executor.heartbeat.interval", "com.liferay.filters.doubleclick.DoubleClickFilter", "com.liferay.portal.servlet.filters.doubleclick.DoubleClickFilter", "commons.pool.enabled", "dl.file.entry.read.count.enabled", "dynamic.data.lists.template.language.parser[ftl]", "dynamic.data.lists.template.language.parser[vm]", "dynamic.data.lists.template.language.parser[xsl]", "dynamic.data.mapping.template.language.types", "ehcache.statistics.enabled", "jbi.workflow.url", "journal.template.language.parser[css]", "journal.template.language.parser[ftl]", "journal.template.language.parser[vm]", "journal.template.language.parser[xsl]", "journal.template.language.types", "lucene.analyzer", "lucene.store.jdbc.auto.clean.up", "lucene.store.jdbc.auto.clean.up.enabled", "lucene.store.jdbc.auto.clean.up.interval", "lucene.store.jdbc.dialect.db2", "lucene.store.jdbc.dialect.derby", "lucene.store.jdbc.dialect.hsqldb", "lucene.store.jdbc.dialect.jtds", "lucene.store.jdbc.dialect.microsoft", "lucene.store.jdbc.dialect.mysql", "lucene.store.jdbc.dialect.oracle", "lucene.store.jdbc.dialect.postgresql", "memory.cluster.scheduler.lock.cache.enabled", "message.boards.thread.locking.enabled", "portal.ctx", "portal.security.manager.enable", "permissions.user.check.algorithm", "scheduler.classes", "schema.run.minimal", "shard.available.names", "velocity.engine.resource.manager", "velocity.engine.resource.manager.cache.enabled", "webdav.storage.class", "webdav.storage.show.edit.url", "webdav.storage.show.view.url", "webdav.storage.tokens", "xss.allow"};
    private static final String[] _OBSOLETE_SYSTEM_KEYS = new String[]{"com.liferay.util.Http.proxy.host", "com.liferay.util.Http.proxy.port", "com.liferay.util.XSSUtil.regexp.pattern"};
    private static final String[][] _RENAMED_PORTAL_KEYS = new String[][]{{"amazon.license.0", "amazon.access.key.id"}, {"amazon.license.1", "amazon.access.key.id"}, {"amazon.license.2", "amazon.access.key.id"}, {"amazon.license.3", "amazon.access.key.id"}, {"cdn.host", "cdn.host.http"}, {"com.liferay.portal.servlet.filters.compression.CompressionFilter", "com.liferay.portal.servlet.filters.gzip.GZipFilter"}, {"default.guest.friendly.url", "default.guest.public.layout.friendly.url"}, {"default.guest.layout.column", "default.guest.public.layout.column"}, {"default.guest.layout.name", "default.guest.public.layout.name"}, {"default.guest.layout.template.id", "default.guest.public.layout.template.id"}, {"default.user.layout.column", "default.user.public.layout.column"}, {"default.user.layout.name", "default.user.public.layout.name"}, {"default.user.layout.template.id", "default.user.public.layout.template.id"}, {"default.user.private.layout.lar", "default.user.private.layouts.lar"}, {"default.user.public.layout.lar", "default.user.public.layouts.lar"}, {"dl.hook.cmis.credentials.password", "dl.store.cmis.credentials.password"}, {"dl.hook.cmis.credentials.username", "dl.store.cmis.credentials.username"}, {"dl.hook.cmis.repository.url", "dl.store.cmis.repository.url"}, {"dl.hook.cmis.system.root.dir", "dl.store.cmis.system.root.dir"}, {"dl.hook.file.system.root.dir", "dl.store.file.system.root.dir"}, {"dl.hook.impl", "dl.store.impl"}, {"dl.hook.jcr.fetch.delay", "dl.store.jcr.fetch.delay"}, {"dl.hook.jcr.fetch.max.failures", "dl.store.jcr.fetch.max.failures"}, {"dl.hook.jcr.move.version.labels", "dl.store.jcr.move.version.labels"}, {"dl.hook.s3.access.key", "dl.store.s3.access.key"}, {"dl.hook.s3.bucket.name", "dl.store.s3.bucket.name"}, {"dl.hook.s3.secret.key", "dl.store.s3.secret.key"}, {"editor.wysiwyg.portal-web.docroot.html.portlet.calendar.edit_configuration.jsp", "editor.wysiwyg.portal-web.docroot.html.portlet.calendar.configuration.jsp"}, {"editor.wysiwyg.portal-web.docroot.html.portlet.invitation.edit_configuration.jsp", "editor.wysiwyg.portal-web.docroot.html.portlet.invitation.configuration.jsp"}, {"editor.wysiwyg.portal-web.docroot.html.portlet.journal.edit_configuration.jsp", "editor.wysiwyg.portal-web.docroot.html.portlet.journal.configuration.jsp"}, {"editor.wysiwyg.portal-web.docroot.html.portlet.message_boards.edit_configuration.jsp", "editor.wysiwyg.portal-web.docroot.html.portlet.message_boards.configuration.jsp"}, {"editor.wysiwyg.portal-web.docroot.html.portlet.shopping.edit_configuration.jsp", "editor.wysiwyg.portal-web.docroot.html.portlet.shopping.configuration.jsp"}, {"field.editable.com.liferay.portal.model.User.emailAddress", "field.editable.user.types"}, {"field.editable.com.liferay.portal.model.User.screenName", "field.editable.user.types"}, {"journal.error.template.freemarker", "journal.error.template[ftl]"}, {"journal.error.template.velocity", "journal.error.template[vm]"}, {"journal.error.template.xsl", "journal.error.template[xsl]"}, {"journal.template.freemarker.restricted.variables", "freemarker.engine.restricted.variables"}, {"journal.template.velocity.restricted.variables", "velocity.engine.restricted.variables"}, {"referer.url.domains.allowed", "redirect.url.domains.allowed"}, {"referer.url.ips.allowed", "redirect.url.ips.allowed"}, {"referer.url.security.mode", "redirect.url.security.mode"}, {"tags.asset.increment.view.counter.enabled", "asset.entry.increment.view.counter.enabled"}};
    private static final String[][] _RENAMED_SYSTEM_KEYS = new String[][]{{"com.liferay.portal.kernel.util.StringBundler.unsafe.create.threshold", "com.liferay.portal.kernel.util.StringBundler.threadlocal.buffer.limit"}};
    private static Log _log = LogFactoryUtil.getLog(VerifyProperties.class);

    @Override
    protected void doVerify() throws Exception {
        String newKey;
        String oldKey;
        String newKey2;
        String oldKey2;
        String[] keys;
        String[][] stringArray = _MIGRATED_SYSTEM_KEYS;
        int n = _MIGRATED_SYSTEM_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            keys = stringArray[n2];
            oldKey2 = keys[0];
            newKey2 = keys[1];
            this.verifyMigratedSystemProperty(oldKey2, newKey2);
            ++n2;
        }
        stringArray = _RENAMED_SYSTEM_KEYS;
        n = _RENAMED_SYSTEM_KEYS.length;
        n2 = 0;
        while (n2 < n) {
            keys = stringArray[n2];
            oldKey2 = keys[0];
            newKey2 = keys[1];
            this.verifyRenamedSystemProperty(oldKey2, newKey2);
            ++n2;
        }
        stringArray = _OBSOLETE_SYSTEM_KEYS;
        n = _OBSOLETE_SYSTEM_KEYS.length;
        n2 = 0;
        while (n2 < n) {
            String[] key = stringArray[n2];
            this.verifyObsoleteSystemProperty((String)key);
            ++n2;
        }
        Properties portalProperties = this.loadPortalProperties();
        String[][] stringArray2 = _MIGRATED_PORTAL_KEYS;
        int n3 = _MIGRATED_PORTAL_KEYS.length;
        n = 0;
        while (n < n3) {
            String[] keys2 = stringArray2[n];
            oldKey = keys2[0];
            newKey = keys2[1];
            this.verifyMigratedPortalProperty(portalProperties, oldKey, newKey);
            ++n;
        }
        stringArray2 = _RENAMED_PORTAL_KEYS;
        n3 = _RENAMED_PORTAL_KEYS.length;
        n = 0;
        while (n < n3) {
            String[] keys3 = stringArray2[n];
            oldKey = keys3[0];
            newKey = keys3[1];
            this.verifyRenamedPortalProperty(portalProperties, oldKey, newKey);
            ++n;
        }
        stringArray2 = _OBSOLETE_PORTAL_KEYS;
        n3 = _OBSOLETE_PORTAL_KEYS.length;
        n = 0;
        while (n < n3) {
            String[] key = stringArray2[n];
            this.verifyObsoletePortalProperty(portalProperties, (String)key);
            ++n;
        }
        StoreFactory.checkProperties();
        this.verifyLDAPProperties();
    }

    protected InputStream getPropertiesResourceAsStream(String resourceName) throws FileNotFoundException {
        File propertyFile = new File(resourceName);
        if (propertyFile.exists()) {
            return new FileInputStream(propertyFile);
        }
        ClassLoader classLoader = VerifyProperties.class.getClassLoader();
        return classLoader.getResourceAsStream(resourceName);
    }

    protected Properties loadPortalProperties() {
        Properties properties = new Properties();
        List propertiesResourceNames = ListUtil.fromArray((Object[])PropsUtil.getArray("include-and-override"));
        propertiesResourceNames.add(0, "portal.properties");
        for (String propertyResourceName : propertiesResourceNames) {
            InputStream inputStream = null;
            try {
                try {
                    inputStream = this.getPropertiesResourceAsStream(propertyResourceName);
                    if (inputStream != null) {
                        properties.load(inputStream);
                    }
                }
                catch (IOException ioe) {
                    _log.error((Object)("Unable to load property " + propertyResourceName), (Throwable)ioe);
                    StreamUtil.cleanUp((InputStream)inputStream);
                    continue;
                }
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(inputStream);
                throw throwable;
            }
            StreamUtil.cleanUp((InputStream)inputStream);
        }
        return properties;
    }

    protected void verifyLDAPProperties() throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long[] ldapServerIds;
            long companyId = lArray[n2];
            UnicodeProperties properties = new UnicodeProperties();
            long[] lArray2 = ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L);
            int n3 = ldapServerIds.length;
            int n4 = 0;
            while (n4 < n3) {
                long ldapServerId = lArray2[n4];
                String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
                String[] stringArray = _LDAP_KEYS;
                int n5 = _LDAP_KEYS.length;
                int n6 = 0;
                while (n6 < n5) {
                    String key = stringArray[n6];
                    String value = PrefsPropsUtil.getString(companyId, String.valueOf(key) + postfix, null);
                    if (value == null) {
                        properties.put(String.valueOf(key) + postfix, "");
                    }
                    ++n6;
                }
                ++n4;
            }
            if (!properties.isEmpty()) {
                CompanyLocalServiceUtil.updatePreferences((long)companyId, (UnicodeProperties)properties);
            }
            ++n2;
        }
    }

    protected void verifyMigratedPortalProperty(Properties portalProperties, String oldKey, String newKey) throws Exception {
        if (portalProperties.containsKey(oldKey)) {
            _log.error((Object)("Portal property \"" + oldKey + "\" was migrated to the system property \"" + newKey + "\""));
        }
    }

    protected void verifyMigratedSystemProperty(String oldKey, String newKey) throws Exception {
        String value = SystemProperties.get((String)oldKey);
        if (value != null) {
            _log.error((Object)("System property \"" + oldKey + "\" was migrated to the portal property \"" + newKey + "\""));
        }
    }

    protected void verifyObsoletePortalProperty(Properties portalProperties, String key) throws Exception {
        if (portalProperties.containsKey(key)) {
            _log.error((Object)("Portal property \"" + key + "\" is obsolete"));
        }
    }

    protected void verifyObsoleteSystemProperty(String key) throws Exception {
        String value = SystemProperties.get((String)key);
        if (value != null) {
            _log.error((Object)("System property \"" + key + "\" is obsolete"));
        }
    }

    protected void verifyRenamedPortalProperty(Properties portalProperties, String oldKey, String newKey) throws Exception {
        if (portalProperties.containsKey(oldKey)) {
            _log.error((Object)("Portal property \"" + oldKey + "\" was renamed to \"" + newKey + "\""));
        }
    }

    protected void verifyRenamedSystemProperty(String oldKey, String newKey) throws Exception {
        String value = SystemProperties.get((String)oldKey);
        if (value != null) {
            _log.error((Object)("System property \"" + oldKey + "\" was renamed to \"" + newKey + "\""));
        }
    }
}

