/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.RolePermissionUtil;
import com.liferay.portal.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.announcements.model.AnnouncementsEntry;
import com.liferay.portlet.announcements.service.base.AnnouncementsEntryServiceBaseImpl;
import com.liferay.portlet.announcements.service.permission.AnnouncementsEntryPermission;

public class AnnouncementsEntryServiceImpl
extends AnnouncementsEntryServiceBaseImpl {
    public AnnouncementsEntry addEntry(long plid, long classNameId, long classPK, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean displayImmediately, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority, boolean alert) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (alert) {
            AnnouncementsEntryPermission.check(permissionChecker, plid, "83", "ADD_ENTRY");
        } else {
            AnnouncementsEntryPermission.check(permissionChecker, plid, "84", "ADD_ENTRY");
        }
        if (classNameId == 0L) {
            if (!PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"ADD_GENERAL_ANNOUNCEMENTS")) {
                throw new PrincipalException();
            }
        } else {
            Team team;
            Role role;
            String className = PortalUtil.getClassName((long)classNameId);
            if (className.equals(Group.class.getName()) && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)"MANAGE_ANNOUNCEMENTS")) {
                throw new PrincipalException();
            }
            if (className.equals(Organization.class.getName()) && !OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)"MANAGE_ANNOUNCEMENTS")) {
                throw new PrincipalException();
            }
            if (className.equals(Role.class.getName()) && ((role = this.roleLocalService.getRole(classPK)).isTeam() ? !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)(team = this.teamLocalService.getTeam(role.getClassPK())).getGroupId(), (String)"MANAGE_ANNOUNCEMENTS") || !RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)team.getGroupId(), (long)classPK, (String)"MANAGE_ANNOUNCEMENTS") : !RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)"MANAGE_ANNOUNCEMENTS"))) {
                throw new PrincipalException();
            }
            if (className.equals(UserGroup.class.getName()) && !UserGroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)"MANAGE_ANNOUNCEMENTS")) {
                throw new PrincipalException();
            }
        }
        return this.announcementsEntryLocalService.addEntry(this.getUserId(), classNameId, classPK, title, content, url, type, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, displayImmediately, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, priority, alert);
    }

    public AnnouncementsEntry addEntry(long plid, long classNameId, long classPK, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority, boolean alert) throws PortalException, SystemException {
        return this.addEntry(plid, classNameId, classPK, title, content, url, type, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, false, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, priority, alert);
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        AnnouncementsEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.announcementsEntryLocalService.deleteEntry(entryId);
    }

    public AnnouncementsEntry getEntry(long entryId) throws PortalException, SystemException {
        AnnouncementsEntry entry = this.announcementsEntryLocalService.getEntry(entryId);
        AnnouncementsEntryPermission.check(this.getPermissionChecker(), entry, "VIEW");
        return entry;
    }

    public AnnouncementsEntry updateEntry(long entryId, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean displayImmediately, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority) throws PortalException, SystemException {
        AnnouncementsEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.announcementsEntryLocalService.updateEntry(this.getUserId(), entryId, title, content, url, type, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, displayImmediately, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, priority);
    }
}

