/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.asset.CategoryPropertyKeyException;
import com.liferay.portlet.asset.CategoryPropertyValueException;
import com.liferay.portlet.asset.model.AssetCategoryProperty;
import com.liferay.portlet.asset.service.base.AssetCategoryPropertyLocalServiceBaseImpl;
import com.liferay.portlet.asset.util.AssetUtil;
import java.util.Date;
import java.util.List;

public class AssetCategoryPropertyLocalServiceImpl
extends AssetCategoryPropertyLocalServiceBaseImpl {
    public AssetCategoryProperty addCategoryProperty(long userId, long categoryId, String key, String value) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(key, value);
        long categoryPropertyId = this.counterLocalService.increment();
        AssetCategoryProperty categoryProperty = this.assetCategoryPropertyPersistence.create(categoryPropertyId);
        categoryProperty.setCompanyId(user.getCompanyId());
        categoryProperty.setUserId(user.getUserId());
        categoryProperty.setUserName(user.getFullName());
        categoryProperty.setCreateDate(now);
        categoryProperty.setModifiedDate(now);
        categoryProperty.setCategoryId(categoryId);
        categoryProperty.setKey(key);
        categoryProperty.setValue(value);
        this.assetCategoryPropertyPersistence.update((BaseModel)categoryProperty);
        return categoryProperty;
    }

    public void deleteCategoryProperties(long entryId) throws SystemException {
        List categoryProperties = this.assetCategoryPropertyPersistence.findByCategoryId(entryId);
        for (AssetCategoryProperty categoryProperty : categoryProperties) {
            this.deleteCategoryProperty(categoryProperty);
        }
    }

    public void deleteCategoryProperty(AssetCategoryProperty categoryProperty) throws SystemException {
        this.assetCategoryPropertyPersistence.remove((BaseModel)categoryProperty);
    }

    public void deleteCategoryProperty(long categoryPropertyId) throws PortalException, SystemException {
        AssetCategoryProperty categoryProperty = this.assetCategoryPropertyPersistence.findByPrimaryKey(categoryPropertyId);
        this.deleteCategoryProperty(categoryProperty);
    }

    public List<AssetCategoryProperty> getCategoryProperties() throws SystemException {
        return this.assetCategoryPropertyPersistence.findAll();
    }

    public List<AssetCategoryProperty> getCategoryProperties(long entryId) throws SystemException {
        return this.assetCategoryPropertyPersistence.findByCategoryId(entryId);
    }

    public AssetCategoryProperty getCategoryProperty(long categoryPropertyId) throws PortalException, SystemException {
        return this.assetCategoryPropertyPersistence.findByPrimaryKey(categoryPropertyId);
    }

    public AssetCategoryProperty getCategoryProperty(long categoryId, String key) throws PortalException, SystemException {
        return this.assetCategoryPropertyPersistence.findByCA_K(categoryId, key);
    }

    public List<AssetCategoryProperty> getCategoryPropertyValues(long groupId, String key) throws SystemException {
        return this.assetCategoryPropertyFinder.findByG_K(groupId, key);
    }

    public AssetCategoryProperty updateCategoryProperty(long categoryPropertyId, String key, String value) throws PortalException, SystemException {
        this.validate(key, value);
        AssetCategoryProperty categoryProperty = this.assetCategoryPropertyPersistence.findByPrimaryKey(categoryPropertyId);
        categoryProperty.setModifiedDate(new Date());
        categoryProperty.setKey(key);
        categoryProperty.setValue(value);
        this.assetCategoryPropertyPersistence.update((BaseModel)categoryProperty);
        return categoryProperty;
    }

    protected void validate(String key, String value) throws PortalException {
        if (!AssetUtil.isValidWord(key)) {
            throw new CategoryPropertyKeyException();
        }
        if (!AssetUtil.isValidWord(value)) {
            throw new CategoryPropertyValueException();
        }
    }
}

