/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.webdav;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.Status;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.webdav.LockException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetLinkLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.webdav.DLFileEntryResourceImpl;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DLWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    public static final String MS_OFFICE_2010_TEXT_XML_UTF8 = "text/xml; charset=\"utf-8\"";
    private static Log _log = LogFactoryUtil.getLog(DLWebDAVStorageImpl.class);

    public int copyCollectionResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite, long depth) throws WebDAVException {
        String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
        long companyId = webDAVRequest.getCompanyId();
        long parentFolderId = 0L;
        try {
            parentFolderId = this.getParentFolderId(companyId, destinationArray);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return 409;
        }
        try {
            Folder folder = (Folder)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String)destination);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name, webDAVRequest.getLockUuid())) {
                status = 204;
            }
            if (depth == 0L) {
                DLAppServiceUtil.addFolder((long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            } else {
                DLAppServiceUtil.copyFolder((long)groupId, (long)folder.getFolderId(), (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            }
            return status;
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return 412;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    public int copySimpleResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        int n;
        File file = null;
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            long companyId = webDAVRequest.getCompanyId();
            long parentFolderId = 0L;
            try {
                parentFolderId = this.getParentFolderId(companyId, destinationArray);
            }
            catch (NoSuchFolderException noSuchFolderException) {
                FileUtil.delete(file);
                return 409;
            }
            FileEntry fileEntry = (FileEntry)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String)destination);
            String mimeType = fileEntry.getMimeType();
            String title = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = fileEntry.getDescription();
            String changeLog = "";
            InputStream is = fileEntry.getContentStream();
            file = FileUtil.createTempFile((InputStream)is);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, title, webDAVRequest.getLockUuid())) {
                status = 204;
            }
            DLAppServiceUtil.addFileEntry((long)groupId, (long)parentFolderId, (String)title, (String)mimeType, (String)title, (String)description, (String)changeLog, (File)file, (ServiceContext)serviceContext);
            n = status;
            FileUtil.delete((File)file);
        }
        catch (DuplicateFileException duplicateFileException) {
            return 412;
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return 412;
        }
        catch (LockException lockException) {
            return 423;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
        finally {
            FileUtil.delete(file);
        }
        return n;
    }

    public int deleteResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        block11: {
            FileEntry fileEntry;
            block12: {
                Resource resource;
                block10: {
                    resource = this.getResource(webDAVRequest);
                    if (resource != null) break block10;
                    if (webDAVRequest.isAppleDoubleRequest()) {
                        return 204;
                    }
                    return 404;
                }
                Object model = resource.getModel();
                if (model instanceof Folder) {
                    Folder folder = (Folder)model;
                    long folderId = folder.getFolderId();
                    if (folder.getModel() instanceof DLFolder && TrashUtil.isTrashEnabled((long)folder.getGroupId())) {
                        DLAppServiceUtil.moveFolderToTrash((long)folderId);
                    } else {
                        DLAppServiceUtil.deleteFolder((long)folderId);
                    }
                    break block11;
                }
                fileEntry = (FileEntry)model;
                if (this.hasLock(fileEntry, webDAVRequest.getLockUuid()) || fileEntry.getLock() == null) break block12;
                return 423;
            }
            try {
                long fileEntryId = fileEntry.getFileEntryId();
                if (fileEntry.getModel() instanceof DLFileEntry && TrashUtil.isTrashEnabled((long)fileEntry.getGroupId())) {
                    DLAppServiceUtil.moveFileEntryToTrash((long)fileEntryId);
                    break block11;
                }
                DLAppServiceUtil.deleteFileEntry((long)fileEntryId);
            }
            catch (PrincipalException principalException) {
                return 403;
            }
            catch (Exception e2) {
                throw new WebDAVException((Throwable)e2);
            }
        }
        return 204;
    }

    public Resource getResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            String[] pathArray = webDAVRequest.getPathArray();
            long companyId = webDAVRequest.getCompanyId();
            long parentFolderId = this.getParentFolderId(companyId, pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            if (Validator.isNull((String)name)) {
                String path = String.valueOf(this.getRootPath()) + webDAVRequest.getPath();
                return new BaseResourceImpl(path, "", this.getToken());
            }
            try {
                Folder folder = DLAppServiceUtil.getFolder((long)webDAVRequest.getGroupId(), (long)parentFolderId, (String)name);
                if (folder.getParentFolderId() != parentFolderId || webDAVRequest.getGroupId() != folder.getRepositoryId()) {
                    throw new NoSuchFolderException();
                }
                return this.toResource(webDAVRequest, folder, false);
            }
            catch (NoSuchFolderException noSuchFolderException) {
                try {
                    String titleWithExtension = name;
                    FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)webDAVRequest.getGroupId(), (long)parentFolderId, (String)titleWithExtension);
                    return this.toResource(webDAVRequest, fileEntry, false);
                }
                catch (NoSuchFileEntryException noSuchFileEntryException) {
                    return null;
                }
            }
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    public List<Resource> getResources(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            long folderId = this.getFolderId(webDAVRequest.getCompanyId(), webDAVRequest.getPathArray());
            List<Resource> folders = this.getFolders(webDAVRequest, folderId);
            List<Resource> fileEntries = this.getFileEntries(webDAVRequest, folderId);
            ArrayList<Resource> resources = new ArrayList<Resource>(folders.size() + fileEntries.size());
            resources.addAll(folders);
            resources.addAll(fileEntries);
            return resources;
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    public boolean isSupportsClassTwo() {
        return true;
    }

    public Status lockResource(WebDAVRequest webDAVRequest, String owner, long timeout) throws WebDAVException {
        Resource resource = this.getResource(webDAVRequest);
        Lock lock = null;
        int status = 200;
        try {
            if (resource == null) {
                status = 201;
                HttpServletRequest request = webDAVRequest.getHttpServletRequest();
                String[] pathArray = webDAVRequest.getPathArray();
                long companyId = webDAVRequest.getCompanyId();
                long groupId = webDAVRequest.getGroupId();
                long parentFolderId = this.getParentFolderId(companyId, pathArray);
                String title = WebDAVUtil.getResourceName((String[])pathArray);
                String extension = FileUtil.getExtension((String)title);
                String contentType = this.getContentType(request, null, title, extension);
                String description = "";
                String changeLog = "";
                File file = FileUtil.createTempFile((String)extension);
                file.createNewFile();
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
                serviceContext.setAddGuestPermissions(true);
                FileEntry fileEntry = DLAppServiceUtil.addFileEntry((long)groupId, (long)parentFolderId, (String)title, (String)contentType, (String)title, (String)description, (String)changeLog, (File)file, (ServiceContext)serviceContext);
                resource = this.toResource(webDAVRequest, fileEntry, false);
            }
            if (resource instanceof DLFileEntryResourceImpl) {
                FileEntry fileEntry = (FileEntry)resource.getModel();
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAttribute("manualCheckInRequired", (Serializable)Boolean.valueOf(webDAVRequest.isManualCheckInRequired()));
                DLAppServiceUtil.checkOutFileEntry((long)fileEntry.getFileEntryId(), (String)owner, (long)timeout, (ServiceContext)serviceContext);
                lock = fileEntry.getLock();
            } else {
                boolean inheritable = false;
                long depth = WebDAVUtil.getDepth((HttpServletRequest)webDAVRequest.getHttpServletRequest());
                if (depth != 0L) {
                    inheritable = true;
                }
                Folder folder = (Folder)resource.getModel();
                lock = DLAppServiceUtil.lockFolder((long)folder.getRepositoryId(), (long)folder.getFolderId(), (String)owner, (boolean)inheritable, (long)timeout);
            }
        }
        catch (Exception e2) {
            if (!(e2 instanceof DuplicateLockException)) {
                throw new WebDAVException((Throwable)e2);
            }
            status = 423;
        }
        return new Status(lock, status);
    }

    public Status makeCollection(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            HttpServletRequest request = webDAVRequest.getHttpServletRequest();
            if (request.getContentLength() > 0) {
                return new Status(415);
            }
            Object[] pathArray = webDAVRequest.getPathArray();
            long companyId = webDAVRequest.getCompanyId();
            long groupId = webDAVRequest.getGroupId();
            long parentFolderId = this.getParentFolderId(companyId, (String[])pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            String description = "";
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(this.isAddGroupPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            DLAppServiceUtil.addFolder((long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            String location = StringUtil.merge((Object[])pathArray, (String)"/");
            return new Status((Object)location, 201);
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return new Status(405);
        }
        catch (DuplicateFileException duplicateFileException) {
            return new Status(405);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return new Status(409);
        }
        catch (PrincipalException principalException) {
            return new Status(403);
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    public int moveCollectionResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            Folder folder = (Folder)resource.getModel();
            long companyId = webDAVRequest.getCompanyId();
            long groupId = WebDAVUtil.getGroupId((long)companyId, (String[])destinationArray);
            long folderId = folder.getFolderId();
            long parentFolderId = this.getParentFolderId(companyId, destinationArray);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setUserId(webDAVRequest.getUserId());
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name, webDAVRequest.getLockUuid())) {
                status = 204;
            }
            if (parentFolderId != folder.getParentFolderId()) {
                DLAppServiceUtil.moveFolder((long)folderId, (long)parentFolderId, (ServiceContext)serviceContext);
            }
            if (!name.equals(folder.getName())) {
                DLAppServiceUtil.updateFolder((long)folderId, (String)name, (String)description, (ServiceContext)serviceContext);
            }
            return status;
        }
        catch (PrincipalException principalException) {
            return 403;
        }
        catch (DuplicateFolderNameException duplicateFolderNameException) {
            return 412;
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    /*
     * Exception decompiling
     */
    public int moveSimpleResource(WebDAVRequest webDAVRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int putResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Lock refreshResourceLock(WebDAVRequest webDAVRequest, String uuid, long timeout) throws WebDAVException {
        Resource resource = this.getResource(webDAVRequest);
        long companyId = webDAVRequest.getCompanyId();
        Lock lock = null;
        try {
            lock = resource instanceof DLFileEntryResourceImpl ? DLAppServiceUtil.refreshFileEntryLock((String)uuid, (long)companyId, (long)timeout) : DLAppServiceUtil.refreshFolderLock((String)uuid, (long)companyId, (long)timeout);
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
        return lock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unlockResource(WebDAVRequest webDAVRequest, String token) throws WebDAVException {
        Resource resource = this.getResource(webDAVRequest);
        try {
            if (!(resource instanceof DLFileEntryResourceImpl)) {
                Folder folder = (Folder)resource.getModel();
                DLAppServiceUtil.unlockFolder((long)folder.getRepositoryId(), (long)folder.getParentFolderId(), (String)folder.getName(), (String)token);
                return true;
            }
            FileEntry fileEntry = (FileEntry)resource.getModel();
            if (fileEntry.isManualCheckInRequired()) {
                return false;
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAttribute("webDAVCheckInMode", (Serializable)Boolean.valueOf(true));
            DLAppServiceUtil.checkInFileEntry((long)fileEntry.getFileEntryId(), (String)token, (ServiceContext)serviceContext);
            if (!webDAVRequest.isAppleDoubleRequest()) return true;
            DLAppServiceUtil.deleteFileEntry((long)fileEntry.getFileEntryId());
            return true;
        }
        catch (Exception e2) {
            if (e2 instanceof InvalidLockException) {
                if (!_log.isWarnEnabled()) return false;
                _log.warn((Object)e2.getMessage());
                return false;
            }
            if (!_log.isWarnEnabled()) return false;
            _log.warn((Object)"Unable to unlock file entry", (Throwable)e2);
            return false;
        }
    }

    protected boolean deleteResource(long groupId, long parentFolderId, String name, String lockUuid) throws Exception {
        try {
            Folder folder = DLAppServiceUtil.getFolder((long)groupId, (long)parentFolderId, (String)name);
            DLAppServiceUtil.deleteFolder((long)folder.getFolderId());
            return true;
        }
        catch (NoSuchFolderException noSuchFolderException) {
            try {
                FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)groupId, (long)parentFolderId, (String)name);
                if (!this.hasLock(fileEntry, lockUuid) && fileEntry.getLock() != null) {
                    throw new LockException();
                }
                DLAppServiceUtil.deleteFileEntryByTitle((long)groupId, (long)parentFolderId, (String)name);
                return true;
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                return false;
            }
        }
    }

    protected String getContentType(HttpServletRequest request, File file, String title, String extension) {
        String contentType = GetterUtil.getString((String)request.getHeader("Content-Type"), (String)"application/octet-stream");
        if (contentType.equals("application/octet-stream") || contentType.equals(MS_OFFICE_2010_TEXT_XML_UTF8)) {
            contentType = MimeTypesUtil.getContentType((File)file, (String)title);
        }
        return contentType;
    }

    protected List<Resource> getFileEntries(WebDAVRequest webDAVRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List fileEntries = DLAppServiceUtil.getFileEntries((long)webDAVRequest.getGroupId(), (long)parentFolderId);
        for (FileEntry fileEntry : fileEntries) {
            Resource resource = this.toResource(webDAVRequest, fileEntry, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getFolderId(long companyId, String[] pathArray) throws Exception {
        return this.getFolderId(companyId, pathArray, false);
    }

    protected long getFolderId(long companyId, String[] pathArray, boolean parent) throws Exception {
        long folderId = 0L;
        if (pathArray.length <= 1) {
            return folderId;
        }
        long groupId = WebDAVUtil.getGroupId((long)companyId, (String[])pathArray);
        int x = pathArray.length;
        if (parent) {
            --x;
        }
        int i2 = 2;
        while (i2 < x) {
            String name = pathArray[i2];
            Folder folder = DLAppServiceUtil.getFolder((long)groupId, (long)folderId, (String)name);
            if (groupId == folder.getRepositoryId()) {
                folderId = folder.getFolderId();
            }
            ++i2;
        }
        return folderId;
    }

    protected List<Resource> getFolders(WebDAVRequest webDAVRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        long groupId = webDAVRequest.getGroupId();
        List folders = DLAppServiceUtil.getFolders((long)groupId, (long)parentFolderId, (boolean)false);
        for (Folder folder : folders) {
            Resource resource = this.toResource(webDAVRequest, folder, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getParentFolderId(long companyId, String[] pathArray) throws Exception {
        return this.getFolderId(companyId, pathArray, true);
    }

    protected boolean hasLock(FileEntry fileEntry, String lockUuid) throws Exception {
        if (Validator.isNull((String)lockUuid)) {
            return fileEntry.hasLock();
        }
        try {
            return DLAppServiceUtil.verifyFileEntryLock((long)fileEntry.getRepositoryId(), (long)fileEntry.getFileEntryId(), (String)lockUuid);
        }
        catch (NoSuchLockException noSuchLockException) {
            return false;
        }
    }

    protected void populateServiceContext(ServiceContext serviceContext, FileEntry fileEntry) throws SystemException {
        String className = DLFileEntryConstants.getClassName();
        long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)className, (long)fileEntry.getFileEntryId());
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)className, (long)fileEntry.getFileEntryId());
        List assetLinks = AssetLinkLocalServiceUtil.getLinks((long)assetEntry.getEntryId());
        long[] assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
        serviceContext.setAssetLinkEntryIds(assetLinkEntryIds);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)className, (long)fileEntry.getFileEntryId());
        serviceContext.setAssetTagNames(assetTagNames);
        ExpandoBridge expandoBridge = fileEntry.getExpandoBridge();
        serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
    }

    protected Resource toResource(WebDAVRequest webDAVRequest, FileEntry fileEntry, boolean appendPath) {
        String parentPath = String.valueOf(this.getRootPath()) + webDAVRequest.getPath();
        String name = "";
        if (appendPath) {
            name = fileEntry.getTitle();
        }
        return new DLFileEntryResourceImpl(webDAVRequest, fileEntry, parentPath, name);
    }

    protected Resource toResource(WebDAVRequest webDAVRequest, Folder folder, boolean appendPath) {
        String parentPath = String.valueOf(this.getRootPath()) + webDAVRequest.getPath();
        String name = "";
        if (appendPath) {
            name = folder.getName();
        }
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, folder.getName(), folder.getCreateDate(), folder.getModifiedDate());
        resource.setModel((Object)folder);
        resource.setClassName(Folder.class.getName());
        resource.setPrimaryKey(folder.getPrimaryKey());
        return resource;
    }
}

