/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMStructurePermission;
import com.liferay.portlet.journal.asset.JournalArticleAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class JournalArticleAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "content";
    private static final boolean _LINKABLE = true;

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.fetchJournalArticle((long)classPK);
        if (article == null) {
            JournalArticleResource articleResource = JournalArticleResourceLocalServiceUtil.getArticleResource((long)classPK);
            if (type == 1) {
                article = JournalArticleLocalServiceUtil.fetchDisplayArticle((long)articleResource.getGroupId(), (String)articleResource.getArticleId());
            }
            if (article == null) {
                article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleResource.getGroupId(), (String)articleResource.getArticleId(), (int)-1);
            }
        }
        JournalArticleAssetRenderer journalArticleAssetRenderer = new JournalArticleAssetRenderer(article);
        journalArticleAssetRenderer.setAssetRendererType(type);
        return journalArticleAssetRenderer;
    }

    public AssetRenderer getAssetRenderer(long groupId, String urlTitle) throws PortalException, SystemException {
        JournalArticle article = JournalArticleServiceUtil.getDisplayArticleByUrlTitle((long)groupId, (String)urlTitle);
        return new JournalArticleAssetRenderer(article);
    }

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public List<Tuple> getClassTypeFieldNames(long classTypeId, Locale locale, int start, int end) throws Exception {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getDDMStructure((long)classTypeId);
        List fieldNames = this.getDDMStructureFieldNames(ddmStructure, locale);
        return ListUtil.subList((List)fieldNames, (int)start, (int)end);
    }

    public int getClassTypeFieldNamesCount(long classTypeId, Locale locale) throws Exception {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getDDMStructure((long)classTypeId);
        List fieldNames = this.getDDMStructureFieldNames(ddmStructure, locale);
        return fieldNames.size();
    }

    public Map<Long, String> getClassTypes(long[] groupIds, Locale locale) throws Exception {
        HashMap<Long, String> classTypes = new HashMap<Long, String>();
        List ddmStructures = DDMStructureServiceUtil.getStructures((long[])groupIds, (long)PortalUtil.getClassNameId((String)JournalArticle.class.getName()));
        for (DDMStructure ddmStructure : ddmStructures) {
            classTypes.put(ddmStructure.getStructureId(), ddmStructure.getName(locale));
        }
        return classTypes;
    }

    public String getType() {
        return TYPE;
    }

    public String getTypeName(Locale locale, boolean hasSubtypes) {
        if (hasSubtypes) {
            return LanguageUtil.get((Locale)locale, (String)"basic-web-content");
        }
        return super.getTypeName(locale, hasSubtypes);
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        LiferayPortletURL portletURL = liferayPortletResponse.createRenderURL("15");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("15", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {}
        return liferayPortletURL;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        if (classTypeId > 0L && !DDMStructurePermission.contains(permissionChecker, classTypeId, "VIEW")) {
            return false;
        }
        return JournalPermission.contains(permissionChecker, groupId, "ADD_ARTICLE");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return JournalArticlePermission.contains(permissionChecker, classPK, actionId);
    }

    public boolean isLinkable() {
        return true;
    }

    public boolean isListable(long classPK) throws SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.fetchLatestArticle((long)classPK, (int)0, (boolean)true);
        return article != null && article.isIndexable();
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/history.png";
    }
}

