/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.atom;

import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.atom.BaseAtomCollectionAdapter;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.util.comparator.ArticleVersionComparator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class JournalArticleAtomCollectionProvider
extends BaseAtomCollectionAdapter<JournalArticle> {
    private static final String _COLLECTION_NAME = "web-content";

    public String getCollectionName() {
        return _COLLECTION_NAME;
    }

    public List<String> getEntryAuthors(JournalArticle journalArticle) {
        ArrayList<String> authors = new ArrayList<String>(1);
        authors.add(journalArticle.getUserName());
        return authors;
    }

    public AtomEntryContent getEntryContent(JournalArticle journalArticle, AtomRequestContext atomRequestContext) {
        return new AtomEntryContent(journalArticle.getContent(), AtomEntryContent.Type.XML);
    }

    public String getEntryId(JournalArticle journalArticle) {
        return journalArticle.getArticleId();
    }

    public String getEntrySummary(JournalArticle entry) {
        return null;
    }

    public String getEntryTitle(JournalArticle journalArticle) {
        return journalArticle.getTitle();
    }

    public Date getEntryUpdated(JournalArticle journalArticle) {
        return journalArticle.getModifiedDate();
    }

    public String getFeedTitle(AtomRequestContext atomRequestContext) {
        return AtomUtil.createFeedTitleFromPortletName(atomRequestContext, "15");
    }

    protected void doDeleteEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        String articleId = resourceName;
        ServiceContext serviceContext = new ServiceContext();
        JournalArticleServiceUtil.deleteArticle((long)groupId, (String)articleId, null, (ServiceContext)serviceContext);
    }

    protected JournalArticle doGetEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        String articleId = resourceName;
        return JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId);
    }

    protected Iterable<JournalArticle> doGetFeedEntries(AtomRequestContext atomRequestContext) throws Exception {
        List<Object> journalArticles = new ArrayList<JournalArticle>();
        long companyId = CompanyThreadLocal.getCompanyId();
        long groupId = atomRequestContext.getLongParameter("groupId");
        if (companyId <= 0L || groupId <= 0L) {
            return journalArticles;
        }
        List folderIds = Collections.emptyList();
        long classNameId = 0L;
        String keywords = null;
        Double version = null;
        String type = atomRequestContext.getParameter("type", "general");
        String structureId = null;
        String templateId = null;
        Date displayDateGT = null;
        Date displayDateLT = new Date();
        int status = 0;
        Date reviewDate = null;
        ArticleVersionComparator obc = new ArticleVersionComparator();
        int count = JournalArticleServiceUtil.searchCount((long)companyId, (long)groupId, folderIds, (long)classNameId, keywords, version, (String)type, structureId, templateId, displayDateGT, (Date)displayDateLT, (int)status, reviewDate);
        AtomPager atomPager = new AtomPager(atomRequestContext, count);
        AtomUtil.saveAtomPagerInRequest(atomRequestContext, atomPager);
        journalArticles = JournalArticleServiceUtil.search((long)companyId, (long)groupId, folderIds, (long)classNameId, keywords, version, (String)type, structureId, templateId, displayDateGT, (Date)displayDateLT, (int)status, reviewDate, (int)atomPager.getStart(), (int)(atomPager.getEnd() + 1), (OrderByComparator)obc);
        return journalArticles;
    }

    protected JournalArticle doPostEntry(String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        long folderId = 0L;
        long classNameId = 0L;
        long classPK = 0L;
        String articleId = "";
        boolean autoArticleId = true;
        Locale locale = LocaleUtil.getDefault();
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(locale, title);
        HashMap descriptionMap = new HashMap();
        String type = atomRequestContext.getParameter("type", "general");
        String structureId = null;
        String templateId = null;
        String layoutUuid = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int displayDateMonth = cal.get(2);
        int displayDateDay = cal.get(5);
        int displayDateYear = cal.get(1);
        int displayDateHour = cal.get(11);
        int displayDateMinute = cal.get(12);
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        boolean indexable = true;
        String articleURL = "";
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(false);
        serviceContext.setAddGuestPermissions(false);
        serviceContext.setScopeGroupId(groupId);
        JournalArticle journalArticle = JournalArticleServiceUtil.addArticle((long)groupId, (long)folderId, (long)classNameId, (long)classPK, (String)articleId, (boolean)autoArticleId, titleMap, descriptionMap, (String)content, (String)type, structureId, templateId, layoutUuid, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)indexable, (String)articleURL, (ServiceContext)serviceContext);
        double version = journalArticle.getVersion();
        int status = 0;
        journalArticle = JournalArticleServiceUtil.updateStatus((long)groupId, (String)journalArticle.getArticleId(), (double)version, (int)status, (String)articleURL, (ServiceContext)serviceContext);
        return journalArticle;
    }

    protected void doPutEntry(JournalArticle journalArticle, String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        long groupId = journalArticle.getGroupId();
        long folderId = journalArticle.getFolderId();
        String articleId = journalArticle.getArticleId();
        double version = journalArticle.getVersion();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        journalArticle = JournalArticleServiceUtil.updateArticle((long)groupId, (long)folderId, (String)articleId, (double)version, (String)content, (ServiceContext)serviceContext);
        int status = 0;
        String articleURL = "";
        JournalArticleServiceUtil.updateStatus((long)groupId, (String)journalArticle.getArticleId(), (double)journalArticle.getVersion(), (int)status, (String)articleURL, (ServiceContext)serviceContext);
    }
}

