/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.journal.FeedTargetLayoutFriendlyUrlException;
import com.liferay.portlet.journal.lar.JournalCreationStrategy;
import com.liferay.portlet.journal.lar.JournalCreationStrategyFactory;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.service.JournalFeedLocalServiceUtil;
import java.util.Map;

public class JournalFeedStagedModelDataHandler
extends BaseStagedModelDataHandler<JournalFeed> {
    public static final String[] CLASS_NAMES = new String[]{JournalFeed.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(JournalFeedStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        JournalFeed feed = JournalFeedLocalServiceUtil.fetchJournalFeedByUuidAndGroupId((String)uuid, (long)groupId);
        if (feed != null) {
            JournalFeedLocalServiceUtil.deleteFeed((JournalFeed)feed);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, JournalFeed feed) throws Exception {
        Element feedElement = portletDataContext.getExportDataElement((ClassedModel)feed);
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)feed.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)feed.getStructureId(), (boolean)true);
        if (ddmStructure != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)feed, (StagedModel)ddmStructure, (String)"strong");
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find DDM structure with key " + feed.getStructureId()));
        }
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.fetchTemplate((long)feed.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (String)feed.getTemplateId());
        if (ddmTemplate != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)feed, (StagedModel)ddmTemplate, (String)"strong");
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find DDM template with key " + feed.getTemplateId()));
        }
        DDMTemplate rendererDDMTemplate = DDMTemplateLocalServiceUtil.fetchTemplate((long)feed.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (String)feed.getRendererTemplateId());
        if (rendererDDMTemplate != null) {
            Element rendererDDMTemplateElement = StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)feed, (StagedModel)rendererDDMTemplate, (String)"strong");
            rendererDDMTemplateElement.addAttribute("rendererDDMTemplate", "true");
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find DDM template with key " + feed.getRendererTemplateId()));
        }
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        String newGroupFriendlyURL = group.getFriendlyURL().substring(1);
        String[] friendlyURLParts = StringUtil.split((String)feed.getTargetLayoutFriendlyUrl(), (char)'/');
        String oldGroupFriendlyURL = friendlyURLParts[2];
        if (newGroupFriendlyURL.equals(oldGroupFriendlyURL)) {
            String targetLayoutFriendlyUrl = StringUtil.replaceFirst((String)feed.getTargetLayoutFriendlyUrl(), (String)("/" + newGroupFriendlyURL + "/"), (String)"/@data_handler_group_friendly_url@/");
            feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        }
        portletDataContext.addClassedModel(feedElement, ExportImportPathUtil.getModelPath((StagedModel)feed), (ClassedModel)feed);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, JournalFeed feed) throws Exception {
        block10: {
            long userId = portletDataContext.getUserId(feed.getUserUuid());
            JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
            long authorId = creationStrategy.getAuthorUserId(portletDataContext, feed);
            if (authorId != 0L) {
                userId = authorId;
            }
            Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
            String newGroupFriendlyURL = group.getFriendlyURL().substring(1);
            String[] friendlyURLParts = StringUtil.split((String)feed.getTargetLayoutFriendlyUrl(), (char)'/');
            String oldGroupFriendlyURL = friendlyURLParts[2];
            if (oldGroupFriendlyURL.equals("@data_handler_group_friendly_url@")) {
                feed.setTargetLayoutFriendlyUrl(StringUtil.replace((String)feed.getTargetLayoutFriendlyUrl(), (String)"@data_handler_group_friendly_url@", (String)newGroupFriendlyURL));
            }
            String feedId = feed.getFeedId();
            boolean autoFeedId = false;
            if (Validator.isNumber((String)feedId) || JournalFeedLocalServiceUtil.fetchFeed((long)portletDataContext.getScopeGroupId(), (String)feedId) != null) {
                autoFeedId = true;
            }
            StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)feed, DDMStructure.class);
            Map ddmStructureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
            String parentDDMStructureKey = MapUtil.getString((Map)ddmStructureKeys, (String)feed.getStructureId(), (String)feed.getStructureId());
            StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)feed, DDMTemplate.class);
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
            String parentDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)feed.getTemplateId(), (String)feed.getTemplateId());
            String parentRendererDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)feed.getRendererTemplateId(), (String)feed.getRendererTemplateId());
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)feed);
            boolean addGroupPermissions = creationStrategy.addGroupPermissions(portletDataContext, feed);
            serviceContext.setAddGroupPermissions(addGroupPermissions);
            boolean addGuestPermissions = creationStrategy.addGuestPermissions(portletDataContext, feed);
            serviceContext.setAddGuestPermissions(addGuestPermissions);
            JournalFeed importedFeed = null;
            try {
                if (portletDataContext.isDataStrategyMirror()) {
                    JournalFeed existingFeed = JournalFeedLocalServiceUtil.fetchJournalFeedByUuidAndGroupId((String)feed.getUuid(), (long)portletDataContext.getScopeGroupId());
                    if (existingFeed == null) {
                        serviceContext.setUuid(feed.getUuid());
                        importedFeed = JournalFeedLocalServiceUtil.addFeed((long)userId, (long)portletDataContext.getScopeGroupId(), (String)feedId, (boolean)autoFeedId, (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)parentRendererDDMTemplateKey, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedFormat(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
                    } else {
                        importedFeed = JournalFeedLocalServiceUtil.updateFeed((long)existingFeed.getGroupId(), (String)existingFeed.getFeedId(), (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)parentRendererDDMTemplateKey, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedFormat(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
                    }
                } else {
                    importedFeed = JournalFeedLocalServiceUtil.addFeed((long)userId, (long)portletDataContext.getScopeGroupId(), (String)feedId, (boolean)autoFeedId, (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)parentRendererDDMTemplateKey, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedFormat(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
                }
                portletDataContext.importClassedModel((ClassedModel)feed, (ClassedModel)importedFeed);
                if (!feedId.equals(importedFeed.getFeedId()) && _log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(5);
                    sb.append("A feed with the ID ");
                    sb.append(feedId);
                    sb.append(" already exists. The new generated ID is ");
                    sb.append(importedFeed.getFeedId());
                    sb.append(".");
                    _log.warn((Object)sb.toString());
                }
            }
            catch (FeedTargetLayoutFriendlyUrlException feedTargetLayoutFriendlyUrlException) {
                if (!_log.isWarnEnabled()) break block10;
                StringBundler sb = new StringBundler(6);
                sb.append("A feed with the ID ");
                sb.append(feedId);
                sb.append(" cannot be imported because layout with friendly ");
                sb.append("URL ");
                sb.append(feed.getTargetLayoutFriendlyUrl());
                sb.append(" does not exist");
                _log.warn((Object)sb.toString());
            }
        }
    }
}

