/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.social;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;

public class MBThreadActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{MBThread.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getBody(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        MBMessage message = this.getMessage(activity);
        if (message.getCategoryId() <= 0L) {
            return "";
        }
        StringBundler sb = new StringBundler(4);
        sb.append(serviceContext.getPortalURL());
        sb.append(serviceContext.getPathMain());
        sb.append("/message_boards/find_category?mbCategoryId=");
        sb.append(message.getCategoryId());
        String categoryLink = sb.toString();
        categoryLink = this.addNoSuchEntryRedirect(categoryLink, MBCategory.class.getName(), message.getCategoryId(), serviceContext);
        return this.wrapLink(categoryLink, "go-to-category", serviceContext);
    }

    protected MBMessage getMessage(SocialActivity activity) throws Exception {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)activity.getClassPK());
        return MBMessageLocalServiceUtil.getMessage((long)thread.getRootMessageId());
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)activity.getClassPK());
        return "/message_boards/find_message?messageId=" + thread.getRootMessageId();
    }

    protected Object[] getTitleArguments(String groupName, SocialActivity activity, String link, String title, ServiceContext serviceContext) {
        String userName = this.getUserName(activity.getUserId(), serviceContext);
        String receiverUserName = "";
        if (activity.getReceiverUserId() > 0L) {
            receiverUserName = this.getUserName(activity.getReceiverUserId(), serviceContext);
        }
        return new Object[]{groupName, userName, receiverUserName, this.wrapLink(link, title)};
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-message-boards-thread-move-to-trash";
            }
            return "activity-message-boards-thread-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-message-boards-thread-restore-from-trash";
            }
            return "activity-message-boards-thread-restore-from-trash-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        MBMessage message = this.getMessage(activity);
        return MBMessagePermission.contains(permissionChecker, message.getMessageId(), actionId);
    }
}

