/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.service.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.trash.model.TrashVersion;
import com.liferay.portlet.trash.service.base.TrashVersionLocalServiceBaseImpl;
import java.util.List;

public class TrashVersionLocalServiceImpl
extends TrashVersionLocalServiceBaseImpl {
    public void addTrashVersion(long trashEntryId, String className, long classPK, int status, UnicodeProperties typeSettingsProperties) throws SystemException {
        long versionId = this.counterLocalService.increment();
        TrashVersion trashVersion = this.trashVersionPersistence.create(versionId);
        trashVersion.setEntryId(trashEntryId);
        trashVersion.setClassName(className);
        trashVersion.setClassPK(classPK);
        if (typeSettingsProperties != null) {
            trashVersion.setTypeSettingsProperties(typeSettingsProperties);
        }
        trashVersion.setStatus(status);
        this.trashVersionPersistence.update((BaseModel)trashVersion);
    }

    public TrashVersion deleteTrashVersion(long entryId, String className, long classPK) throws SystemException {
        TrashVersion trashVersion = this.fetchVersion(entryId, className, classPK);
        if (trashVersion != null) {
            return this.deleteTrashVersion(trashVersion);
        }
        return null;
    }

    public TrashVersion fetchVersion(long entryId, String className, long classPK) throws SystemException {
        List<TrashVersion> trashVersions = this.getVersions(className, classPK);
        if (trashVersions.isEmpty()) {
            return null;
        }
        return trashVersions.get(0);
    }

    public List<TrashVersion> getVersions(long entryId) throws SystemException {
        return this.trashVersionPersistence.findByEntryId(entryId);
    }

    public List<TrashVersion> getVersions(long entryId, String className) throws SystemException {
        if (Validator.isNull((String)className)) {
            return this.trashVersionPersistence.findByEntryId(entryId);
        }
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.trashVersionPersistence.findByE_C(entryId, classNameId);
    }

    public List<TrashVersion> getVersions(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.trashVersionPersistence.findByC_C(classNameId, classPK);
    }
}

