/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bi.reporting.messaging;

import com.liferay.portal.kernel.bi.reporting.ReportEngine;
import com.liferay.portal.kernel.bi.reporting.ReportGenerationException;
import com.liferay.portal.kernel.bi.reporting.ReportRequest;
import com.liferay.portal.kernel.bi.reporting.ReportResultContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;

public class ReportRequestMessageListener
implements MessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ReportRequestMessageListener.class);
    private ReportEngine _reportEngine;
    private ReportResultContainer _reportResultContainer;

    public ReportRequestMessageListener(ReportEngine reportEngine, ReportResultContainer reportResultContainer) {
        this._reportEngine = reportEngine;
        this._reportResultContainer = reportResultContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        ReportRequest request = (ReportRequest)message.getPayload();
        ReportResultContainer reportResultContainer = this._reportResultContainer.clone(request.getReportName());
        Message responseMessage = MessageBusUtil.createResponseMessage(message);
        try {
            this._reportEngine.execute(request, reportResultContainer);
        }
        catch (ReportGenerationException rge) {
            _log.error("Unable to generate report", rge);
            reportResultContainer.setReportGenerationException(rge);
        }
        finally {
            responseMessage.setPayload(reportResultContainer);
            MessageBusUtil.sendMessage(responseMessage.getDestination(), responseMessage);
        }
    }
}

