/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cal;

import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Recurrence;
import java.util.Calendar;

public class RecurrenceSerializer {
    public static String toCronText(Recurrence recurrence) {
        Calendar dtStart = recurrence.getDtStart();
        int frequency = recurrence.getFrequency();
        int interval = recurrence.getInterval();
        DayAndPosition[] byDay = recurrence.getByDay();
        int[] byMonthDay = recurrence.getByMonthDay();
        int[] byMonth = recurrence.getByMonth();
        String startDateSecond = String.valueOf(dtStart.get(13));
        String startDateMinute = String.valueOf(dtStart.get(12));
        int startDateHour = dtStart.get(10);
        if (dtStart.get(9) == 1) {
            startDateHour += 12;
        }
        String dayOfMonth = String.valueOf(dtStart.get(5));
        String month = String.valueOf(dtStart.get(2) + 1);
        String dayOfWeek = String.valueOf(dtStart.get(7));
        String year = String.valueOf(dtStart.get(1));
        if (frequency == 7) {
            dayOfWeek = "?";
        } else if (frequency == 3) {
            dayOfMonth = dayOfMonth + "/" + interval;
            month = "*";
            dayOfWeek = "?";
            year = "*";
            if (byDay != null) {
                dayOfMonth = "?";
                dayOfWeek = "";
                for (int i = 0; i < byDay.length; ++i) {
                    if (i > 0) {
                        dayOfWeek = dayOfWeek + ",";
                    }
                    dayOfWeek = dayOfWeek + byDay[i].getDayOfWeek();
                }
            }
        } else if (frequency == 4) {
            dayOfMonth = "?";
            month = "*";
            year = "*";
            if (byDay != null) {
                dayOfWeek = "";
                for (int i = 0; i < byDay.length; ++i) {
                    if (i > 0) {
                        dayOfWeek = dayOfWeek + ",";
                    }
                    dayOfWeek = dayOfWeek + byDay[i].getDayOfWeek();
                }
            }
            dayOfWeek = dayOfWeek + "/" + interval;
        } else if (frequency == 5) {
            dayOfMonth = "?";
            month = month + "/" + interval;
            dayOfWeek = "?";
            year = "*";
            if (byMonthDay != null && byMonthDay.length == 1) {
                dayOfMonth = String.valueOf(byMonthDay[0]);
            } else if (byDay != null && byDay.length == 1) {
                String pos = String.valueOf(byDay[0].getDayPosition());
                dayOfWeek = pos.equals("-1") ? byDay[0].getDayOfWeek() + "L" : byDay[0].getDayOfWeek() + "#" + pos;
            }
        } else if (frequency == 6) {
            dayOfMonth = "?";
            dayOfWeek = "?";
            year = year + "/" + interval;
            if (byMonth != null && byMonth.length == 1) {
                month = String.valueOf(byMonth[0] + 1);
                if (byMonthDay != null && byMonthDay.length == 1) {
                    dayOfMonth = String.valueOf(byMonthDay[0]);
                } else if (byDay != null && byDay.length == 1) {
                    String pos = String.valueOf(byDay[0].getDayPosition());
                    dayOfWeek = pos.equals("-1") ? byDay[0].getDayOfWeek() + "L" : byDay[0].getDayOfWeek() + "#" + pos;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(startDateSecond);
        sb.append(" ");
        sb.append(startDateMinute);
        sb.append(" ");
        sb.append(startDateHour);
        sb.append(" ");
        sb.append(dayOfMonth);
        sb.append(" ");
        sb.append(month);
        sb.append(" ");
        sb.append(dayOfWeek);
        sb.append(" ");
        sb.append(year);
        return sb.toString();
    }
}

