/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class FinderCacheUtil {
    private static Log _log = LogFactoryUtil.getLog(FinderCacheUtil.class);
    private static FinderCache _finderCache;

    public static void clearCache() {
        FinderCacheUtil.getFinderCache().clearCache();
    }

    public static void clearCache(String className) {
        FinderCacheUtil.getFinderCache().clearCache(className);
    }

    public static void clearLocalCache() {
        FinderCacheUtil.getFinderCache().clearLocalCache();
    }

    public static FinderCache getFinderCache() {
        return _finderCache;
    }

    public static Object getResult(String className, String methodName, String[] params, Object[] args, SessionFactory sessionFactory) {
        _log.error("Regenerate " + className + " via \"ant build-service\" or else caching will not work");
        return null;
    }

    public static Object getResult(FinderPath finderPath, Object[] args, SessionFactory sessionFactory) {
        return FinderCacheUtil.getFinderCache().getResult(finderPath, args, sessionFactory);
    }

    public static void invalidate() {
        FinderCacheUtil.getFinderCache().invalidate();
    }

    public static void putResult(boolean classNameCacheEnabled, String className, String methodName, String[] params, Object[] args, Object result) {
        _log.error("Regenerate " + className + " via \"ant build-service\" or else caching will not work");
    }

    public static void putResult(FinderPath finderPath, Object[] args, Object result) {
        FinderCacheUtil.getFinderCache().putResult(finderPath, args, result);
    }

    public static void removeResult(FinderPath finderPath, Object[] args) {
        FinderCacheUtil.getFinderCache().removeResult(finderPath, args);
    }

    public static void setLocalCacheEnabled(boolean localCacheEnabled) {
        FinderCacheUtil.getFinderCache().setLocalCacheEnabled(localCacheEnabled);
    }

    public void setFinderCache(FinderCache finderCache) {
        _finderCache = finderCache;
    }
}

