/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileCacheOutputStream
extends OutputStream {
    private static final int _BUFFER = 2048;
    private static final String _EXTENSION = ".fcos";
    protected BufferedOutputStream _bos;
    protected File _tempFile = File.createTempFile(PortalUUIDUtil.generate() + "-", ".fcos");

    public FileCacheOutputStream() throws IOException {
        this._bos = new BufferedOutputStream(new FileOutputStream(this._tempFile), 2048);
    }

    public void close() throws IOException {
        this._bos.close();
    }

    public void flush() throws IOException {
        this._bos.flush();
    }

    public byte[] getBytes() throws IOException {
        this.flush();
        this.close();
        return FileUtil.getBytes(this._tempFile);
    }

    public File getFile() throws IOException {
        this.flush();
        this.close();
        return this._tempFile;
    }

    public FileInputStream getFileInputStream() throws IOException {
        this.flush();
        this.close();
        return new FileInputStream(this._tempFile);
    }

    public long getSize() {
        return this._tempFile.length();
    }

    public void write(byte[] b) throws IOException {
        this._bos.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._bos.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this._bos.write(b);
    }
}

