/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.ConcurrentHashSet;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayDispatcherDestination
extends BaseDestination {
    private static Log _log = LogFactoryUtil.getLog(ArrayDispatcherDestination.class);
    private Set<MessageListener> _listeners = new ConcurrentHashSet<MessageListener>();

    public ArrayDispatcherDestination(String name) {
        super(name);
    }

    public ArrayDispatcherDestination(String name, int workersCoreSize, int workersMaxSize) {
        super(name, workersCoreSize, workersMaxSize);
    }

    @Override
    public int getListenerCount() {
        return this._listeners.size();
    }

    @Override
    public void register(MessageListener listener) {
        listener = new InvokerMessageListener(listener);
        this._listeners.add(listener);
    }

    @Override
    public void send(Message message) {
        if (this._listeners.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug("No listeners for destination " + this.getName());
            }
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        if (threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("Destination " + this.getName() + " is shutdown and cannot " + "receive more messages");
        }
        this.dispatch(this._listeners, message);
    }

    @Override
    public boolean unregister(MessageListener listener) {
        listener = new InvokerMessageListener(listener);
        return this._listeners.remove(listener);
    }

    protected abstract void dispatch(Set<MessageListener> var1, Message var2);
}

