/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class BaseDestination
implements Destination {
    private static final int _WORKERS_CORE_SIZE = 2;
    private static final int _WORKERS_MAX_SIZE = 5;
    private static Log _log = LogFactoryUtil.getLog(BaseDestination.class);
    private String _name;
    private ThreadPoolExecutor _threadPoolExecutor;
    private int _workersCoreSize;
    private int _workersMaxSize;

    public BaseDestination(String name) {
        this(name, 2, 5);
    }

    public BaseDestination(String name, int workersCoreSize, int workersMaxSize) {
        this._name = name;
        this._workersCoreSize = workersCoreSize;
        this._workersMaxSize = workersMaxSize;
        this.open();
    }

    public synchronized void close() {
        this.close(false);
    }

    public synchronized void close(boolean force) {
        this.doClose(force);
    }

    public DestinationStatistics getStatistics() {
        DestinationStatistics statistics = new DestinationStatistics();
        statistics.setActiveThreadCount(this._threadPoolExecutor.getActiveCount());
        statistics.setCurrentThreadCount(this._threadPoolExecutor.getPoolSize());
        statistics.setLargestThreadCount(this._threadPoolExecutor.getLargestPoolSize());
        statistics.setMaxThreadPoolSize(this._threadPoolExecutor.getMaximumPoolSize());
        statistics.setMinThreadPoolSize(this._threadPoolExecutor.getCorePoolSize());
        statistics.setPendingMessageCount(this._threadPoolExecutor.getQueue().size());
        statistics.setSentMessageCount(this._threadPoolExecutor.getCompletedTaskCount());
        return statistics;
    }

    public abstract int getListenerCount();

    public String getName() {
        return this._name;
    }

    public boolean isRegistered() {
        return this.getListenerCount() > 0;
    }

    public synchronized void open() {
        this.doOpen();
    }

    protected void doClose(boolean force) {
        if (!this._threadPoolExecutor.isShutdown() && !this._threadPoolExecutor.isTerminating()) {
            if (!force) {
                this._threadPoolExecutor.shutdown();
            } else {
                List<Runnable> pendingTasks = this._threadPoolExecutor.shutdownNow();
                if (_log.isInfoEnabled()) {
                    _log.info("The following " + pendingTasks.size() + " tasks " + "were not executed due to shutown: " + pendingTasks);
                }
            }
        }
    }

    protected void doOpen() {
        if (this._threadPoolExecutor == null || this._threadPoolExecutor.isShutdown()) {
            this._threadPoolExecutor = new ThreadPoolExecutor(this._workersCoreSize, this._workersMaxSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(this.getName(), 5));
        }
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return this._threadPoolExecutor;
    }

    protected int getWorkersCoreSize() {
        return this._workersCoreSize;
    }

    protected int getWorkersMaxSize() {
        return this._workersMaxSize;
    }
}

