/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;

public abstract class BaseMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(BaseMessageListener.class);
    private MessageSender _responseSender;
    private SingleDestinationMessageSender _statusSender;

    public BaseMessageListener(SingleDestinationMessageSender statusSender, MessageSender responseSender) {
        this._statusSender = statusSender;
        this._responseSender = responseSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        MessageStatus messageStatus = new MessageStatus();
        messageStatus.startTimer();
        try {
            this.doReceive(message, messageStatus);
        }
        catch (Exception e) {
            _log.error("Unable to process request " + message.getDestination(), e);
            messageStatus.setException(e);
        }
        finally {
            messageStatus.stopTimer();
            this._statusSender.send(messageStatus);
        }
    }

    protected abstract void doReceive(Message var1, MessageStatus var2) throws Exception;

    protected MessageSender getResponseSender() {
        return this._responseSender;
    }
}

