/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.config;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.config.MessagingConfigurator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessagingConfigurator
implements MessagingConfigurator {
    private List<DestinationEventListener> _destinationEventListeners = new ArrayList<DestinationEventListener>();
    private List<Destination> _destinations = new ArrayList<Destination>();
    private Map<String, List<MessageListener>> _messageListeners = new HashMap<String, List<MessageListener>>();

    @Override
    public void destroy() {
        MessageBus messageBus = this.getMessageBus();
        for (Map.Entry<String, List<MessageListener>> listeners : this._messageListeners.entrySet()) {
            String destination = listeners.getKey();
            for (MessageListener listener : listeners.getValue()) {
                messageBus.unregisterMessageListener(destination, listener);
            }
        }
        for (Destination destination : this._destinations) {
            messageBus.removeDestination(destination.getName());
        }
        for (DestinationEventListener listener : this._destinationEventListeners) {
            messageBus.removeDestinationEventListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        MessageBus messageBus = this.getMessageBus();
        for (DestinationEventListener listener : this._destinationEventListeners) {
            messageBus.addDestinationEventListener(listener);
        }
        for (Destination destination : this._destinations) {
            messageBus.addDestination(destination);
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader operatingClassLoader = this.getOperatingClassloader();
            Thread.currentThread().setContextClassLoader(operatingClassLoader);
            for (Map.Entry<String, List<MessageListener>> listeners : this._messageListeners.entrySet()) {
                String destination = listeners.getKey();
                for (MessageListener listener : listeners.getValue()) {
                    messageBus.registerMessageListener(destination, listener);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public void setDestinationEventListeners(List<DestinationEventListener> destinationEventListeners) {
        this._destinationEventListeners = destinationEventListeners;
    }

    @Override
    public void setDestinations(List<Destination> destinations) {
        this._destinations = destinations;
    }

    @Override
    public void setMessageListeners(Map<String, List<MessageListener>> messageListeners) {
        this._messageListeners = messageListeners;
    }

    protected abstract MessageBus getMessageBus();

    protected abstract ClassLoader getOperatingClassloader();
}

