/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.jmx;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.jmx.DestinationManager;
import com.liferay.portal.kernel.messaging.jmx.DestinationStatisticsManager;
import com.liferay.portal.kernel.messaging.jmx.MessageBusManager;
import java.util.Collection;
import javax.management.MBeanServer;

public class JMXMessageListener
implements DestinationEventListener {
    private static Log log = LogFactoryUtil.getLog(JMXMessageListener.class);
    private MBeanServer _mBeanServer;
    private MessageBus _messageBus;

    public void destinationAdded(Destination destination) {
        try {
            this.registerDestination(destination);
        }
        catch (Exception e) {
            log.error("Unable to register destination " + destination.getName(), e);
        }
    }

    public void destinationRemoved(Destination destination) {
        try {
            this.unregisterDestination(destination);
        }
        catch (Exception e) {
            log.error("Unable to unregister destination " + destination.getName(), e);
        }
    }

    public void destroy() throws Exception {
        this._mBeanServer.unregisterMBean(MessageBusManager.createObjectName());
    }

    public void init() throws Exception {
        if (this._mBeanServer == null || this._messageBus == null) {
            throw new IllegalStateException("MBean server and message bus are not configured");
        }
        this._mBeanServer.registerMBean(new MessageBusManager(this._messageBus), MessageBusManager.createObjectName());
        Collection<Destination> destinations = this._messageBus.getDestinations();
        for (Destination destination : destinations) {
            this.registerDestination(destination);
        }
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this._mBeanServer = mBeanServer;
    }

    public void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }

    protected void registerDestination(Destination destination) throws Exception {
        String destinationName = destination.getName();
        this._mBeanServer.registerMBean(new DestinationManager(destination), DestinationManager.createObjectName(destinationName));
        this._mBeanServer.registerMBean(new DestinationStatisticsManager(destination), DestinationStatisticsManager.createObjectName(destinationName));
    }

    protected void unregisterDestination(Destination destination) throws Exception {
        String destinationName = destination.getName();
        this._mBeanServer.unregisterMBean(DestinationManager.createObjectName(destinationName));
        this._mBeanServer.unregisterMBean(DestinationStatisticsManager.createObjectName(destinationName));
    }
}

