/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.sender;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageListener;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUID;

public class DefaultSynchronousMessageSender
implements SynchronousMessageSender {
    private static Log _log = LogFactoryUtil.getLog(DefaultSynchronousMessageSender.class);
    private MessageBus _messageBus;
    private PortalUUID _portalUUID;
    private long _timeout;

    public DefaultSynchronousMessageSender(MessageBus messageBus, PortalUUID portalUUID, long timeout) {
        this._messageBus = messageBus;
        this._portalUUID = portalUUID;
        this._timeout = timeout;
    }

    public Object sendMessage(String destination, Message message) throws MessageBusException {
        return this.sendMessage(destination, message, this._timeout);
    }

    public Object sendMessage(String destination, Message message, long timeout) throws MessageBusException {
        if (!this._messageBus.hasDestination(destination)) {
            return null;
        }
        message.setDestination(destination);
        String responseDestination = message.getResponseDestination();
        if (Validator.isNull(responseDestination) || !this._messageBus.hasDestination(responseDestination)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Response destination " + responseDestination + " is not configured");
            }
            message.setResponseDestination("liferay/message_bus/default_response");
        }
        String responseId = this._portalUUID.generate();
        message.setResponseId(responseId);
        SynchronousMessageListener synchronousMessageListener = new SynchronousMessageListener(this._messageBus, message, timeout);
        return synchronousMessageListener.send();
    }
}

