/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.sender;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageListener;

public class SynchronousMessageListener
implements MessageListener {
    private MessageBus _messageBus;
    private Message _message;
    private long _timeout;
    private String _responseId;
    private Object _results;

    public SynchronousMessageListener(MessageBus messageBus, Message message, long timeout) {
        this._messageBus = messageBus;
        this._message = message;
        this._timeout = timeout;
        this._responseId = this._message.getResponseId();
    }

    public Object getResults() {
        return this._results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        if (!message.getResponseId().equals(this._responseId)) {
            return;
        }
        SynchronousMessageListener synchronousMessageListener = this;
        synchronized (synchronousMessageListener) {
            this._results = message.getPayload();
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object send() throws MessageBusException {
        String destination = this._message.getDestination();
        String responseDestination = this._message.getResponseDestination();
        this._messageBus.registerMessageListener(responseDestination, this);
        try {
            Object object = this;
            synchronized (object) {
                this._messageBus.sendMessage(destination, this._message);
                this.wait(this._timeout);
                if (this._results == null) {
                    throw new MessageBusException("No reply received for message: " + this._message);
                }
            }
            object = this._results;
            return object;
        }
        catch (InterruptedException ie) {
            throw new MessageBusException("Message sending interrupted for: " + this._message, ie);
        }
        finally {
            this._messageBus.unregisterMessageListener(responseDestination, this);
        }
    }
}

