/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFilter
implements Filter {
    private static final String _DEPTHER = "DEPTHER";
    private FilterConfig _filterConfig;
    private Class<?> _filterClass = this.getClass();
    private boolean _filterEnabled = true;
    private Pattern _urlRegexPattern;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._filterConfig = filterConfig;
        String urlRegexPattern = GetterUtil.getString(filterConfig.getInitParameter("url-regex-pattern"));
        if (Validator.isNotNull(urlRegexPattern)) {
            this._urlRegexPattern = Pattern.compile(urlRegexPattern);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            if (this.isFilterEnabled()) {
                log.debug(this._filterClass + " is enabled");
            } else {
                log.debug(this._filterClass + " is disabled");
            }
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean filterEnabled = this.isFilterEnabled();
        if (filterEnabled && this._urlRegexPattern != null) {
            Matcher matcher = this._urlRegexPattern.matcher(request.getRequestURL());
            filterEnabled = matcher.matches();
        }
        if (filterEnabled) {
            this.processFilter(request, response, filterChain);
        } else {
            this.processFilter(this._filterClass, request, response, filterChain);
        }
    }

    public FilterConfig getFilterConfig() {
        return this._filterConfig;
    }

    public void destroy() {
    }

    protected abstract Log getLog();

    protected boolean isFilterEnabled() {
        return this._filterEnabled;
    }

    protected abstract void processFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected void processFilter(Class<?> filterClass, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        long startTime = 0L;
        String threadName = null;
        String depther = null;
        String path = null;
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Thread currentThread = Thread.currentThread();
            threadName = currentThread.getName();
            depther = (String)request.getAttribute(_DEPTHER);
            depther = depther == null ? "" : depther + "=";
            request.setAttribute(_DEPTHER, (Object)depther);
            path = request.getRequestURI();
            log.debug("[" + threadName + "]" + depther + "> " + filterClass.getName() + " " + path);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (log.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            depther = (String)request.getAttribute(_DEPTHER);
            log.debug("[" + threadName + "]" + depther + "< " + filterClass.getName() + " " + path + " " + (endTime - startTime) + " ms");
            if (depther.length() > 0) {
                depther = depther.substring(1);
            }
            request.setAttribute(_DEPTHER, (Object)depther);
        }
    }
}

