/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalInitable;
import com.liferay.portal.kernel.util.PortalInitableUtil;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public abstract class PortalClassLoaderServletContextListener
implements PortalInitable,
ServletContextListener {
    private static Log _log = LogFactoryUtil.getLog(PortalClassLoaderServletContextListener.class);
    private ServletContextEvent _event;
    private ServletContextListener _servletContextListener;
    private ClassLoader _portletClassLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent event) {
        PortletClassLoaderUtil.setClassLoader(this._portletClassLoader);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            this._servletContextListener.contextDestroyed(event);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        this._event = event;
        Thread currentThread = Thread.currentThread();
        this._portletClassLoader = currentThread.getContextClassLoader();
        PortalInitableUtil.init(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void portalInit() {
        PortletClassLoaderUtil.setClassLoader(this._portletClassLoader);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            this._servletContextListener = this.getInstance();
            this._servletContextListener.contextInitialized(this._event);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected abstract ServletContextListener getInstance() throws Exception;
}

