/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class PortletSessionTracker
implements HttpSessionBindingListener,
Serializable {
    private static PortletSessionTracker _instance = new PortletSessionTracker();
    private transient Map<String, Set<HttpSession>> _sessions = new HashMap<String, Set<HttpSession>>();

    public static void add(HttpSession session) {
        _instance._add(session);
    }

    public static HttpSessionBindingListener getInstance() {
        return _instance;
    }

    public static void invalidate(String sessionId) {
        _instance._invalidate(sessionId);
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        PortletSessionTracker.invalidate(event.getSession().getId());
    }

    private PortletSessionTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _add(HttpSession session) {
        String sessionId = session.getId();
        Map<String, Set<HttpSession>> map = this._sessions;
        synchronized (map) {
            Set<HttpSession> portletSessions = this._sessions.get(sessionId);
            if (portletSessions == null) {
                portletSessions = new HashSet<HttpSession>();
                this._sessions.put(sessionId, portletSessions);
            }
            portletSessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _invalidate(String sessionId) {
        Map<String, Set<HttpSession>> map = this._sessions;
        synchronized (map) {
            Set<HttpSession> portletSessions = this._sessions.get(sessionId);
            if (portletSessions != null) {
                for (HttpSession session : portletSessions) {
                    try {
                        session.invalidate();
                    }
                    catch (Exception e) {}
                }
            }
            this._sessions.remove(sessionId);
        }
    }
}

