/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.StringServletOutputStream;
import com.liferay.portal.kernel.util.ByteArrayMaker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class StringServletResponse
extends HttpServletResponseWrapper {
    private static Log _log = LogFactoryUtil.getLog(StringServletResponse.class);
    private String _contentType;
    private int _status = 200;
    private ByteArrayMaker _bam = new ByteArrayMaker();
    private ServletOutputStream _sos = new StringServletOutputStream(this._bam);
    private StringWriter _sw = new StringWriter();
    private PrintWriter _pw = new PrintWriter(this._sw);
    private int _bufferSize;
    private boolean _callGetOutputStream;
    private boolean _callGetWriter;
    private String _string = null;

    public StringServletResponse(HttpServletResponse response) {
        super(response);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public ByteArrayMaker getByteArrayMaker() {
        return this._bam;
    }

    public String getContentType() {
        return this._contentType;
    }

    public ServletOutputStream getOutputStream() {
        this._callGetOutputStream = true;
        return this._sos;
    }

    public int getStatus() {
        return this._status;
    }

    public String getString() {
        if (this._string != null) {
            return this._string;
        }
        if (this._callGetOutputStream) {
            try {
                return this._bam.toString("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                _log.error(uee, uee);
                return "";
            }
        }
        if (this._callGetWriter) {
            return this._sw.toString();
        }
        return "";
    }

    public PrintWriter getWriter() {
        this._callGetWriter = true;
        return this._pw;
    }

    public boolean isCalledGetOutputStream() {
        return this._callGetOutputStream;
    }

    public void recycle() {
        this._bam.reset();
        this._status = 200;
        this._sw = new StringWriter();
        this._pw = new PrintWriter(this._sw);
        this._callGetOutputStream = false;
        this._callGetWriter = false;
        this._string = null;
    }

    public void resetBuffer() {
        if (this._callGetOutputStream) {
            this._bam.reset();
        } else if (this._callGetWriter) {
            StringBuffer sb = this._sw.getBuffer();
            sb.delete(0, sb.length());
        }
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
        super.setContentType(contentType);
    }

    public void setLocale(Locale locale) {
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public void setString(String string) {
        this._string = string;
    }
}

