/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class WebDirDetector {
    private static Log _log = LogFactoryUtil.getLog(WebDirDetector.class);

    public static String getLibDir(ClassLoader classLoader) {
        int pos;
        String libDir;
        URL url = classLoader.getResource("com/liferay/util/bean/PortletBeanLocatorUtil.class");
        String file = null;
        try {
            file = new URI(url.getPath()).getPath();
        }
        catch (URISyntaxException urise) {
            file = url.getFile();
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Lib url " + file);
        }
        if ((libDir = file.substring(0, (pos = file.indexOf("/com/liferay/util/bean/")) + 1)).endsWith("/WEB-INF/classes/")) {
            libDir = libDir.substring(0, libDir.length() - 8) + "lib/";
        } else {
            pos = libDir.indexOf("/WEB-INF/lib/");
            if (pos != -1) {
                libDir = libDir.substring(0, pos) + "/WEB-INF/lib/";
            }
        }
        if (libDir.startsWith("file:/")) {
            libDir = libDir.substring(5, libDir.length());
        }
        return libDir;
    }

    public static String getRootDir(ClassLoader classLoader) {
        return WebDirDetector.getRootDir(WebDirDetector.getLibDir(classLoader));
    }

    public static String getRootDir(String libDir) {
        String rootDir = libDir;
        if (rootDir.endsWith("/WEB-INF/lib/")) {
            rootDir = rootDir.substring(0, rootDir.length() - 12);
        }
        return rootDir;
    }
}

