/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class CalendarUtil {
    public static String[] DAYS_ABBREVIATION = new String[]{"sunday-abbreviation", "monday-abbreviation", "tuesday-abbreviation", "wednesday-abbreviation", "thursday-abbreviation", "friday-abbreviation", "saturday-abbreviation"};
    public static int[] MONTH_IDS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static Map<String, String[]> _calendarPool = new ConcurrentHashMap<String, String[]>();

    public static boolean afterByDay(Date date1, Date date2) {
        long millis2;
        long millis1 = CalendarUtil._getTimeInMillis(date1);
        return millis1 > (millis2 = CalendarUtil._getTimeInMillis(date2));
    }

    public static boolean beforeByDay(Date date1, Date date2) {
        long millis2;
        long millis1 = CalendarUtil._getTimeInMillis(date1);
        return millis1 < (millis2 = CalendarUtil._getTimeInMillis(date2));
    }

    public static boolean equalsByDay(Date date1, Date date2) {
        long millis2;
        long millis1 = CalendarUtil._getTimeInMillis(date1);
        return millis1 == (millis2 = CalendarUtil._getTimeInMillis(date2));
    }

    public static int getAge(Date date, TimeZone tz) {
        return CalendarUtil.getAge(date, CalendarFactoryUtil.getCalendar(tz));
    }

    public static int getAge(Date date, Calendar today) {
        Calendar birthday = CalendarFactoryUtil.getCalendar();
        birthday.setTime(date);
        int yearDiff = today.get(1) - birthday.get(1);
        if (today.get(2) < birthday.get(2)) {
            --yearDiff;
        } else if (today.get(2) == birthday.get(2) && today.get(5) < birthday.get(5)) {
            --yearDiff;
        }
        return yearDiff;
    }

    public static String[] getDays(Locale locale) {
        return CalendarUtil.getDays(locale, null);
    }

    public static String[] getDays(Locale locale, String pattern) {
        if (Validator.isNull(pattern)) {
            pattern = "EEEE";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("days_");
        sb.append(pattern);
        sb.append("_");
        sb.append(locale.getLanguage());
        sb.append("_");
        sb.append(locale.getCountry());
        String key = sb.toString();
        String[] days = _calendarPool.get(key);
        if (days == null) {
            days = new String[7];
            SimpleDateFormat dayFormat = new SimpleDateFormat(pattern, locale);
            Calendar cal = CalendarFactoryUtil.getCalendar();
            cal.set(5, 1);
            for (int i = 0; i < 7; ++i) {
                cal.set(7, i + 1);
                days[i] = dayFormat.format(cal.getTime());
            }
            _calendarPool.put(key, days);
        }
        return days;
    }

    public static int getDaysInMonth(Calendar cal) {
        return CalendarUtil.getDaysInMonth(cal.get(2), cal.get(1));
    }

    public static int getDaysInMonth(int month, int year) {
        if (++month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            return 31;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return 29;
        }
        return 28;
    }

    public static int getGregorianDay(Calendar cal) {
        int year = cal.get(1) - 1600;
        int month = cal.get(2) + 1;
        if (month < 3) {
            month += 12;
        }
        int day = cal.get(5);
        int gregorianDay = (int)(6286.0 + (double)year * 365.25 - (double)(year / 100) + (double)(year / 400) + 30.6 * (double)month + 0.2 + (double)day);
        return gregorianDay;
    }

    public static Date getGTDate(Calendar cal) {
        Calendar gtCal = (Calendar)cal.clone();
        gtCal.set(11, 0);
        gtCal.set(12, 0);
        gtCal.set(13, 0);
        gtCal.set(14, 0);
        return gtCal.getTime();
    }

    public static int getLastDayOfWeek(Calendar cal) {
        int firstDayOfWeek = cal.getFirstDayOfWeek();
        if (firstDayOfWeek == 1) {
            return 7;
        }
        if (firstDayOfWeek == 2) {
            return 1;
        }
        if (firstDayOfWeek == 3) {
            return 2;
        }
        if (firstDayOfWeek == 4) {
            return 3;
        }
        if (firstDayOfWeek == 5) {
            return 4;
        }
        if (firstDayOfWeek == 6) {
            return 5;
        }
        return 6;
    }

    public static Date getLTDate(Calendar cal) {
        Calendar ltCal = (Calendar)cal.clone();
        ltCal.set(11, 23);
        ltCal.set(12, 59);
        ltCal.set(13, 59);
        ltCal.set(14, 999);
        return ltCal.getTime();
    }

    public static int[] getMonthIds() {
        return MONTH_IDS;
    }

    public static String[] getMonths(Locale locale) {
        return CalendarUtil.getMonths(locale, null);
    }

    public static String[] getMonths(Locale locale, String pattern) {
        if (Validator.isNull(pattern)) {
            pattern = "MMMM";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("months_");
        sb.append(pattern);
        sb.append("_");
        sb.append(locale.getLanguage());
        sb.append("_");
        sb.append(locale.getCountry());
        String key = sb.toString();
        String[] months = _calendarPool.get(key);
        if (months == null) {
            months = new String[12];
            SimpleDateFormat monthFormat = new SimpleDateFormat(pattern, locale);
            Calendar cal = CalendarFactoryUtil.getCalendar();
            cal.set(5, 1);
            for (int i = 0; i < 12; ++i) {
                cal.set(2, i);
                months[i] = monthFormat.format(cal.getTime());
            }
            _calendarPool.put(key, months);
        }
        return months;
    }

    public static Timestamp getTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static boolean isAfter(int month1, int day1, int year1, int hour1, int minute1, int amPm1, int month2, int day2, int year2, int hour2, int minute2, int amPm2, TimeZone timeZone, Locale locale) {
        Calendar cal1 = CalendarFactoryUtil.getCalendar(timeZone, locale);
        cal1.set(2, month1);
        cal1.set(5, day1);
        cal1.set(1, year1);
        cal1.set(10, hour1);
        cal1.set(12, minute1);
        cal1.set(9, amPm1);
        Calendar cal2 = CalendarFactoryUtil.getCalendar(timeZone, locale);
        cal2.set(2, month2);
        cal2.set(5, day2);
        cal2.set(1, year2);
        cal2.set(10, hour2);
        cal2.set(12, minute2);
        cal2.set(9, amPm2);
        return cal1.after(cal2);
    }

    public static boolean isBroadcastDate(int month, int day, int year) {
        if (!CalendarUtil.isDate(month, day, year)) {
            return false;
        }
        Calendar cal1 = CalendarFactoryUtil.getCalendar();
        cal1.setFirstDayOfWeek(2);
        cal1.set(2, month);
        cal1.set(5, day);
        cal1.set(1, year);
        Calendar cal2 = CalendarFactoryUtil.getCalendar();
        cal2.setFirstDayOfWeek(2);
        cal2.set(2, month + 1);
        cal2.set(5, 1);
        cal2.set(1, year);
        return cal2.get(7) == 2 || cal2.get(3) != cal1.get(3);
    }

    public static boolean isDate(int month, int day, int year) {
        return Validator.isDate(month, day, year);
    }

    public static boolean isFuture(int month, int year) {
        return CalendarUtil.isFuture(month, year, TimeZoneUtil.getDefault(), LocaleUtil.getDefault());
    }

    public static boolean isFuture(int month, int year, TimeZone timeZone, Locale locale) {
        Calendar curCal = CalendarFactoryUtil.getCalendar(timeZone, locale);
        curCal.set(5, 1);
        Calendar cal = (Calendar)curCal.clone();
        cal.set(2, month);
        cal.set(1, year);
        return cal.after(curCal);
    }

    public static boolean isFuture(int month, int day, int year) {
        return CalendarUtil.isFuture(month, day, year, TimeZoneUtil.getDefault(), LocaleUtil.getDefault());
    }

    public static boolean isFuture(int month, int day, int year, TimeZone timeZone, Locale locale) {
        Calendar curCal = CalendarFactoryUtil.getCalendar(timeZone, locale);
        Calendar cal = (Calendar)curCal.clone();
        cal.set(2, month);
        cal.set(5, day);
        cal.set(1, year);
        return cal.after(curCal);
    }

    public static boolean isFuture(int month, int day, int year, int hour, int minute, int amPm) {
        return CalendarUtil.isFuture(month, day, year, hour, minute, amPm, TimeZoneUtil.getDefault(), LocaleUtil.getDefault());
    }

    public static boolean isFuture(int month, int day, int year, int hour, int minute, int amPm, TimeZone timeZone, Locale locale) {
        Calendar curCal = CalendarFactoryUtil.getCalendar(timeZone, locale);
        Calendar cal = (Calendar)curCal.clone();
        cal.set(2, month);
        cal.set(5, day);
        cal.set(1, year);
        cal.set(10, hour);
        cal.set(12, minute);
        cal.set(9, amPm);
        return cal.after(curCal);
    }

    public static boolean isGregorianDate(int month, int day, int year) {
        return Validator.isGregorianDate(month, day, year);
    }

    public static boolean isJulianDate(int month, int day, int year) {
        return Validator.isJulianDate(month, day, year);
    }

    public static Calendar roundByMinutes(Calendar cal, int interval) {
        int minutes = cal.get(12);
        int delta = 0;
        delta = minutes < interval ? interval - minutes : interval - minutes % interval;
        if (delta == interval) {
            delta = 0;
        }
        cal.add(12, delta);
        return cal;
    }

    private static long _getTimeInMillis(Date date) {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = 0;
        int minute = 0;
        int second = 0;
        cal.set(year, month, day, hour, minute, second);
        long millis = cal.getTimeInMillis() / 86400000L;
        return millis;
    }
}

