/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListUtil {
    public static List copy(List master) {
        if (master == null) {
            return null;
        }
        return new ArrayList(master);
    }

    public static void copy(List master, List copy) {
        if (master == null || copy == null) {
            return;
        }
        copy.clear();
        for (Object obj : master) {
            copy.add(obj);
        }
    }

    public static void distinct(List list) {
        ListUtil.distinct(list, null);
    }

    public static void distinct(List list, Comparator comparator) {
        if (list == null || list.size() == 0) {
            return;
        }
        TreeSet set = null;
        set = comparator == null ? new TreeSet() : new TreeSet(comparator);
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (set.contains(obj)) {
                itr.remove();
                continue;
            }
            set.add(obj);
        }
    }

    public static List fromArray(Object[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static List fromCollection(Collection c) {
        if (c != null && c instanceof List) {
            return (List)c;
        }
        if (c == null || c.size() == 0) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList(c.size());
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            list.add(itr.next());
        }
        return list;
    }

    public static List fromEnumeration(Enumeration enu) {
        ArrayList list = new ArrayList();
        while (enu.hasMoreElements()) {
            Object obj = enu.nextElement();
            list.add(obj);
        }
        return list;
    }

    public static List fromFile(String fileName) throws IOException {
        return ListUtil.fromFile(new File(fileName));
    }

    public static List fromFile(File file) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String s = "";
        while ((s = br.readLine()) != null) {
            list.add(s);
        }
        br.close();
        return list;
    }

    public static List fromString(String s) {
        return ListUtil.fromArray(StringUtil.split(s, "\n"));
    }

    public static List sort(List list) {
        return ListUtil.sort(list, null);
    }

    public static List sort(List list, Comparator comparator) {
        if (list instanceof UnmodifiableList) {
            list = ListUtil.copy(list);
        }
        Collections.sort(list, comparator);
        return list;
    }

    public static List subList(List list, int start, int end) {
        ArrayList newList = new ArrayList();
        int normalizedSize = list.size() - 1;
        if (start < 0 || start > normalizedSize || end < 0 || start > end) {
            return newList;
        }
        for (int i = start; i < end && i <= normalizedSize; ++i) {
            newList.add(list.get(i));
        }
        return newList;
    }

    public static List<Boolean> toList(boolean[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>(array.length);
        for (boolean value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Double> toList(double[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Double> list = new ArrayList<Double>(array.length);
        for (double value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Float> toList(float[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Float> list = new ArrayList<Float>(array.length);
        for (float value : array) {
            list.add(Float.valueOf(value));
        }
        return list;
    }

    public static List<Integer> toList(int[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Long> toList(long[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> list = new ArrayList<Long>(array.length);
        for (long value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Short> toList(short[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Short> list = new ArrayList<Short>(array.length);
        for (short value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Boolean> toList(Boolean[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>(array.length);
        for (Boolean value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Double> toList(Double[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Double> list = new ArrayList<Double>(array.length);
        for (Double value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Float> toList(Float[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Float> list = new ArrayList<Float>(array.length);
        for (Float value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Integer> toList(Integer[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (Integer value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Long> toList(Long[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> list = new ArrayList<Long>(array.length);
        for (Long value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Short> toList(Short[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Short> list = new ArrayList<Short>(array.length);
        for (Short value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<String> toList(String[] array) {
        if (array == null || array.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>(array.length);
        for (String value : array) {
            list.add(value);
        }
        return list;
    }

    public static String toString(List list, String param) {
        return ListUtil.toString(list, param, ",");
    }

    public static String toString(List list, String param, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Object bean = list.get(i);
            Object value = BeanPropertiesUtil.getObject(bean, param);
            if (value == null) {
                value = "";
            }
            sb.append(value.toString());
            if (i + 1 == list.size()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }
}

