/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LocaleUtil {
    private static Log _log = LogFactoryUtil.getLog(LocaleUtil.class);
    private static LocaleUtil _instance = new LocaleUtil();
    private Locale _locale;
    private Map<String, Locale> _locales = new HashMap<String, Locale>();

    public static Locale fromLanguageId(String languageId) {
        return _instance._fromLanguageId(languageId);
    }

    public static Locale[] fromLanguageIds(String[] languageIds) {
        return _instance._fromLanguageIds(languageIds);
    }

    public static Locale getDefault() {
        return _instance._getDefault();
    }

    public static LocaleUtil getInstance() {
        return _instance;
    }

    public static void setDefault(String userLanguage, String userCountry, String userVariant) {
        _instance._setDefault(userLanguage, userCountry, userVariant);
    }

    public static String toLanguageId(Locale locale) {
        return _instance._toLanguageId(locale);
    }

    public static String[] toLanguageIds(Locale[] locales) {
        return _instance._toLanguageIds(locales);
    }

    private LocaleUtil() {
        this._locale = new Locale("en", "US");
    }

    private Locale _fromLanguageId(String languageId) {
        Locale locale;
        block7: {
            if (languageId == null) {
                return this._locale;
            }
            locale = null;
            try {
                locale = this._locales.get(languageId);
                if (locale == null) {
                    int pos = languageId.indexOf("_");
                    if (pos == -1) {
                        locale = new Locale(languageId);
                    } else {
                        String languageCode = languageId.substring(0, pos);
                        String countryCode = languageId.substring(pos + 1, languageId.length());
                        locale = new Locale(languageCode, countryCode);
                    }
                    this._locales.put(languageId, locale);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn(languageId + " is not a valid language id");
            }
        }
        if (locale == null) {
            locale = this._locale;
        }
        return locale;
    }

    private Locale[] _fromLanguageIds(String[] languageIds) {
        Locale[] locales = new Locale[languageIds.length];
        for (int i = 0; i < languageIds.length; ++i) {
            locales[i] = this._fromLanguageId(languageIds[i]);
        }
        return locales;
    }

    private Locale _getDefault() {
        return this._locale;
    }

    public void _setDefault(String userLanguage, String userCountry, String userVariant) {
        if (Validator.isNotNull(userLanguage) && Validator.isNull(userCountry) && Validator.isNull(userVariant)) {
            this._locale = new Locale(userLanguage);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNull(userVariant)) {
            this._locale = new Locale(userLanguage, userCountry);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNotNull(userVariant)) {
            this._locale = new Locale(userLanguage, userCountry, userVariant);
        }
    }

    private String _toLanguageId(Locale locale) {
        if (locale == null) {
            locale = this._locale;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(locale.getLanguage());
        if (Validator.isNotNull(locale.getCountry())) {
            sb.append("_");
            sb.append(locale.getCountry());
        }
        return sb.toString();
    }

    private String[] _toLanguageIds(Locale[] locales) {
        String[] languageIds = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            languageIds[i] = this._toLanguageId(locales[i]);
        }
        return languageIds;
    }
}

