/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Randomizer
extends Random {
    private static Randomizer _instance = new Randomizer();

    public static Randomizer getInstance() {
        return _instance;
    }

    public Randomizer() {
    }

    public Randomizer(long seed) {
        super(seed);
    }

    public int[] nextInt(int n, int size) {
        if (size > n) {
            size = n;
        }
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            Integer value;
            while (set.contains(value = new Integer(this.nextInt(n)))) {
            }
            set.add(value);
        }
        int[] array = new int[set.size()];
        Iterator itr = set.iterator();
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Integer)itr.next();
        }
        return array;
    }

    public void randomize(char[] array) {
        int length = array.length;
        for (int i = 0; i < length - 1; ++i) {
            int x = this.nextInt(length);
            char y = array[i];
            array[i] = array[i + x];
            array[i + x] = y;
            --length;
        }
    }

    public void randomize(int[] array) {
        int length = array.length;
        for (int i = 0; i < length - 1; ++i) {
            int x = this.nextInt(length);
            int y = array[i];
            array[i] = array[i + x];
            array[i + x] = y;
            --length;
        }
    }

    public void randomize(List<Object> list) {
        int size = list.size();
        for (int i = 0; i <= size; --size, ++i) {
            Object obj = list.get(i);
            int j = this.nextInt(size);
            list.set(i, list.get(i + j));
            list.set(i + j, obj);
        }
    }

    public void randomize(Object[] array) {
        int length = array.length;
        for (int i = 0; i < length - 1; ++i) {
            int x = this.nextInt(length);
            Object y = array[i];
            array[i] = array[i + x];
            array[i + x] = y;
            --length;
        }
    }

    public String randomize(String s) {
        if (s == null) {
            return null;
        }
        char[] array = s.toCharArray();
        this.randomize(array);
        return new String(array);
    }
}

