/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;

public class ServerDetector {
    public static final String GERONIMO_ID = "geronimo";
    public static final String GLASSFISH_ID = "glassfish";
    public static final String JBOSS_ID = "jboss";
    public static final String JETTY_ID = "jetty";
    public static final String JONAS_ID = "jonas";
    public static final String OC4J_ID = "oc4j";
    public static final String RESIN_ID = "resin";
    public static final String TOMCAT_ID = "tomcat";
    public static final String WEBLOGIC_ID = "weblogic";
    public static final String WEBSPHERE_ID = "websphere";
    private static Log _log = LogFactoryUtil.getLog(ServerDetector.class);
    private static ServerDetector _instance = new ServerDetector();
    private String _serverId;
    private Boolean _geronimo;
    private Boolean _glassfish;
    private Boolean _glassfish2;
    private Boolean _glassfish3;
    private Boolean _jBoss;
    private Boolean _jetty;
    private Boolean _jonas;
    private Boolean _oc4j;
    private Boolean _resin;
    private Boolean _tomcat;
    private Boolean _webLogic;
    private Boolean _webSphere;

    public static String getServerId() {
        ServerDetector sd = _instance;
        if (sd._serverId == null) {
            if (ServerDetector.isGeronimo()) {
                sd._serverId = GERONIMO_ID;
            } else if (ServerDetector.isGlassfish()) {
                sd._serverId = GLASSFISH_ID;
            } else if (ServerDetector.isJBoss()) {
                sd._serverId = JBOSS_ID;
            } else if (ServerDetector.isJOnAS()) {
                sd._serverId = JONAS_ID;
            } else if (ServerDetector.isOC4J()) {
                sd._serverId = OC4J_ID;
            } else if (ServerDetector.isResin()) {
                sd._serverId = RESIN_ID;
            } else if (ServerDetector.isWebLogic()) {
                sd._serverId = WEBLOGIC_ID;
            } else if (ServerDetector.isWebSphere()) {
                sd._serverId = WEBSPHERE_ID;
            }
            if (ServerDetector.isJetty()) {
                sd._serverId = sd._serverId == null ? JETTY_ID : sd._serverId + "-jetty";
            } else if (ServerDetector.isTomcat()) {
                sd._serverId = sd._serverId == null ? TOMCAT_ID : sd._serverId + "-tomcat";
            }
            if (_log.isInfoEnabled()) {
                if (sd._serverId != null) {
                    _log.info("Detected server " + sd._serverId);
                } else {
                    _log.info("No server detected");
                }
            }
            if (sd._serverId == null) {
                throw new RuntimeException("Server is not supported");
            }
        }
        return sd._serverId;
    }

    public static boolean isGeronimo() {
        ServerDetector sd = _instance;
        if (sd._geronimo == null) {
            sd._geronimo = ServerDetector._detect("/org/apache/geronimo/system/main/Daemon.class");
        }
        return sd._geronimo;
    }

    public static boolean isGlassfish() {
        ServerDetector sd = _instance;
        if (sd._glassfish == null) {
            String value = System.getProperty("com.sun.aas.instanceRoot");
            sd._glassfish = value != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._glassfish;
    }

    public static boolean isGlassfish2() {
        ServerDetector sd = _instance;
        if (sd._glassfish2 == null) {
            sd._glassfish2 = ServerDetector.isGlassfish() && !ServerDetector.isGlassfish3() ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._glassfish2;
    }

    public static boolean isGlassfish3() {
        ServerDetector sd = _instance;
        if (sd._glassfish3 == null) {
            String value = "";
            if (ServerDetector.isGlassfish()) {
                value = GetterUtil.getString(System.getProperty("product.name"));
            }
            sd._glassfish3 = value.equals("GlassFish/v3") ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._glassfish3;
    }

    public static boolean isJBoss() {
        ServerDetector sd = _instance;
        if (sd._jBoss == null) {
            sd._jBoss = ServerDetector._detect("/org/jboss/Main.class");
        }
        return sd._jBoss;
    }

    public static boolean isJetty() {
        ServerDetector sd = _instance;
        if (sd._jetty == null) {
            sd._jetty = ServerDetector._detect("/org/mortbay/jetty/Server.class");
        }
        return sd._jetty;
    }

    public static boolean isJOnAS() {
        ServerDetector sd = _instance;
        if (sd._jonas == null) {
            sd._jonas = ServerDetector._detect("/org/objectweb/jonas/server/Server.class");
        }
        return sd._jonas;
    }

    public static boolean isOC4J() {
        ServerDetector sd = _instance;
        if (sd._oc4j == null) {
            sd._oc4j = ServerDetector._detect("oracle.oc4j.util.ClassUtils");
        }
        return sd._oc4j;
    }

    public static boolean isResin() {
        ServerDetector sd = _instance;
        if (sd._resin == null) {
            sd._resin = ServerDetector._detect("/com/caucho/server/resin/Resin.class");
        }
        return sd._resin;
    }

    public static boolean isSupportsComet() {
        return false;
    }

    public static boolean isTomcat() {
        ServerDetector sd = _instance;
        if (sd._tomcat == null) {
            sd._tomcat = ServerDetector._detect("/org/apache/catalina/startup/Bootstrap.class");
        }
        if (sd._tomcat == null) {
            sd._tomcat = ServerDetector._detect("/org/apache/catalina/startup/Embedded.class");
        }
        return sd._tomcat;
    }

    public static boolean isWebLogic() {
        ServerDetector sd = _instance;
        if (sd._webLogic == null) {
            sd._webLogic = ServerDetector._detect("/weblogic/Server.class");
        }
        return sd._webLogic;
    }

    public static boolean isWebSphere() {
        ServerDetector sd = _instance;
        if (sd._webSphere == null) {
            sd._webSphere = ServerDetector._detect("/com/ibm/websphere/product/VersionInfo.class");
        }
        return sd._webSphere;
    }

    private static Boolean _detect(String className) {
        try {
            ClassLoader.getSystemClassLoader().loadClass(className);
            return Boolean.TRUE;
        }
        catch (ClassNotFoundException cnfe) {
            ServerDetector sd = _instance;
            Class<?> c = sd.getClass();
            if (c.getResource(className) != null) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    private ServerDetector() {
    }
}

